
uniform float time;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;
out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1 && time>.0f) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	vec3 wpos = (object_to_clip*pos).xyz;
	wpos.z -= .9;
	gl_Position = vec4(wpos, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, kotilo;

out vec4 out_color;

void main() {
	vec2 nuv = uv*2.0-vec2(sin(uv.y*4.0+time)*.1, time*.04);
	vec4 col = texture(image, nuv);
	vec4 kot = texture(kotilo, vec2(.0,.5)+2.0*uv*vec2(.5, 1.0)-vec2(.02*time, .0));
	out_color = mix(vec4(col.xyz, smoothstep(192.0, 193.0, time+col.x+nuv.x)), mix(kot, vec4(.5, .5, .5, 1.0), .9*smoothstep(267.5, 269.5, time)), smoothstep(260.0, 262.0, time))*vec4(vec3(smoothstep(308.0, 300.0, time)),1.0);
	if(out_color.w<.99 && time<290.0)
		discard;
}

#endif
