
uniform float time;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;
out vec2 uv;
out vec3 wpos;
uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1 && time>.0f) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	wpos = (object_to_clip*pos).xyz;
	wpos.z += .1;
	gl_Position = vec4(wpos, 1.0);
}

#endif

#ifdef fragment

in vec3 wpos;
in vec2 uv;

uniform sampler2D image;

out vec4 out_color;

void main() {
	float a = .0;
	for(float i = .0; i<10.0; i += 1.0)
		a += .5+.5*sin(((uv.x+3.0*sin(uv.x))*4.0/(i+1.0)+uv.y+.1*time)*i*5.0+4.0*uv.x+(wpos.y*2.0+wpos.x*a*.4+time*.1)*(i+1.0)*2.0+a+i);
	float caustic = a*.1*smoothstep(.6, .4, uv.y);
	out_color = texture(image, uv)*vec4(mix(vec3(.6), vec3(.1, .1, 1.0), clamp(caustic, .0, 1.0)), 1.0);
	if(out_color.w<.5)
		discard;
}

#endif
