
#ifdef vertex

in vec2 position;

out vec2 uv;

void main() {
	uv = position*.5+vec2(.5);
	gl_Position = vec4(position, 1.0, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, bloom;
out vec4 out_color;

uniform vec3 lift = vec3(.0), gain = vec3(1.0), gamma = vec3(1.0);
uniform float time;

float nois(vec3 x) {
	return fract(14999.913*cos(19.193*dot(x, vec3(1.931, 1.7193, .03137))));
}

void main() {
	vec3 col = texture(image, uv).rgb;
	for(float i = .0; i<12.0; ++i) {
		col += textureLod(bloom, uv, 1.4+i*.9).rgb/(i+1.0)*smoothstep(5.0, 6.0, time)*smoothstep(308.0, 300.0, time);
	}
	vec3 graded = pow(clamp((gain*col+lift*(1.0-gain*col)),vec3(.0),vec3(1.0)),vec3(1.0)/gamma);

	out_color = vec4(graded+ vec3(nois(vec3(gl_FragCoord.xy, time))/512.0), 1.0);
}

#endif
