
#define warp_size 32
#define warp_count 8

#ifdef compute

// nicer names (wtf ARB, why gl_loqdwjqiicvoajiojqwiojtlakstjiqowjtioqtjiqo)
#define thread int(gl_LocalInvocationID)
#define gthread int(gl_GlobalInvocationID)

#define block_threads (warp_size * warp_count)

layout (local_size_x = block_threads) in;

buffer position_buffer {
	vec4 position[];
};

buffer velocity_buffer {
	vec4 velocity[];
};

buffer emitter_buffer {
	vec4 emitter[];
};

uniform sampler3D noise;

uniform int first_to_emit, emit_count_1, emit_count_2, total_particles;
uniform float time;

void main() {
	vec4 emit_pos, emit_vel, rnd_scale = vec4(1.0, 1.0, 1.0, .0);
	if(time<160.0) {
		if(gthread<emit_count_1) {
			emit_pos = emitter[0];
			emit_vel = emitter[1];
			emit_pos.z = -.9;
			emit_vel.z = -.9;
		}
		else if(gthread<emit_count_1+emit_count_2) {
			emit_pos = emitter[2];
			emit_vel = emitter[3];
			emit_pos.z = -.5;
			emit_vel.z = -.5;
		} else
			return;
	} else {
		if(gthread<emit_count_1) {
			rnd_scale = vec4(1.0, .01, 1.0, .0);
			emit_pos = emitter[0];
			emit_pos.z = -.5;
			emit_vel = vec4(emit_pos.xyz, emit_pos.w);
		}
		else if(gthread<emit_count_1+emit_count_2) {
			rnd_scale = vec4(1.0, .01, 1.0, .0);
			emit_pos = emitter[2];
			emit_pos.z = -.5;
			emit_vel = vec4(emit_pos.xyz-vec3(1.0, -1.0, .0), emit_pos.w);
		}
		else return;
	}
	
	int pthread = gthread + first_to_emit;

	vec4 pos = vec4(emit_pos.xyz, 1.0) + emit_pos.w* rnd_scale * 2.0*(texture(noise, vec3(float(int(pthread*2)), float(int((pthread*2)/256)), float(int(((pthread*2)/256)/256)))/256.0)-vec4(.5));
	vec4 vel = 1000.0*(vec4(emit_vel.xyz-emit_pos.xyz, .0) + emit_vel.w * .1*(texture(noise, vec3(float(int(pthread*2+1)), float(int((pthread*2+1)/256)), float(int(((pthread*2+1)/256)/256)))/256.0)-vec4(.5)));
	if(time<160.0)
		pos.w = .001*length(vel.xyz);
	position[(gthread+first_to_emit)%total_particles] = pos;
	velocity[(gthread+first_to_emit)%total_particles] = vel;
}

#endif
