
uniform sampler2D image, normdd, background, z_depth;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;

out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);

	gl_Position = vec4((object_to_clip*pos).xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;
uniform float time;
out vec4 out_color;

void main() {
	vec4 mask = texture(image, uv);
	if(mask.a>.5) {
		vec4 depth_sample = texture(z_depth, uv);
		if(depth_sample.g<depth_sample.r-.1)
			gl_FragDepth = .1f;
		else
			gl_FragDepth = .5f;
		if(mask.r<.5) {
			vec3 normal = normalize(pow(texture(normdd, uv).xyz, vec3(2.2))*2.0-vec3(1.0)+ sin(2.0*vec3(uv*50.0, time*.5+(uv.x+uv.y)*40.0))*.2 );
			vec3 sample_dir = reflect(vec3(.0, .0, -1.0), normal);
			vec3 col = texture(background, sample_dir.xy*.5 + vec2(.0, .2)).xyz;
			col = pow(col, vec3(4.0));
			out_color = vec4(col * .2*sin(vec3(sample_dir.x+5.0*sample_dir.y, sample_dir.x*5.0, sample_dir.x+5.0*sample_dir.y)), 1.0);
		}
		else
			out_color = vec4(1.0, 1.0, 1.0, .4 );
	}
	else
		discard;
}

#endif
