var Strobo = function(){
  PartBase.call(this);
  this.initScene();
}

Strobo.prototype = PartBase.prototype.inheritance();

Strobo.prototype.initScene = function(){
  //Ei käytä default inittiä, koska erilainen kamera!
  
  this.scene = new THREE.Scene();
  this.shader = stroboShader();
  
  //otetaan käyttöön toinen kamera
	this.camera = new THREE.OrthographicCamera(TDEMO.minx, TDEMO.maxx, TDEMO.maxy, TDEMO.miny);
	this.camera.position.z = 1;
	this.scene.add(this.camera);
  
  this.material = new THREE.ShaderMaterial({
    uniforms: this.shader.uniforms,
    vertexShader: this.shader.vertexShader,
    fragmentShader: this.shader.fragmentShader
  });
  
  this.display = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height),
    this.material);
	this.display.position.z = -1;
  this.scene.add(this.display);
  
}

Strobo.prototype.animate = function(timeStep, elapsedTime){
  PartBase.prototype.animate.call(this, timeStep, elapsedTime);
  this.shader.uniforms.time.value = this.elapsed;
}
