var kaariShader = function(){
  
  var uniforms = { 
    "resolution": { type: "v2", value: new THREE.Vector2(1910, 1070) },
    "time": { type: "f", value: 0.0 },
    "phase": { type: "f", value: 0.0}
  };
  
  var vertexShader = [
		"void main() {",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n");
  
  var fragmentShader = [
    "uniform vec2 resolution;",
    "uniform float time;",
    "uniform float phase;",

    "const vec3 AMBIENT = vec3(5.0, 5.0, 1.0);",
    "const vec3 DIFFUSE = vec3(0.3, 0.3, 0.8);",
    "const vec3 SPECULAR = vec3(0.1, 0.19, 0.5);",

    "float box( vec3 p, vec3 b ){",
      "vec3 d = abs(p) - b;",
      "return min(max(d.x,max(d.y,d.z)),0.0)+length(max(d,0.0));",
    "}",

    "vec3 rotateY(vec3 p, float a){",
      "float c = cos(a);",
      "float s = sin(a);",
      "vec3 q = p;",
      "q.x = c * p.x + s * p.z;",
      "q.z = -s * p.x + c * p.z;",
      "return q;",
    "}",

    "vec3 rotateZ(vec3 p, float a){",
      "float c = cos(a);",
      "float s = sin(a);",
      "vec3 q = p;",
      "q.x = c * p.x - s * p.y;",
      "q.y = s * p.x + c * p.y;",
      "return q;",
    "}",

    "float repeat(float p, float c){",
      "return mod(p+(0.5*c), c)-0.5*c;",
    "}",

    "float map(vec3 p){",
      "vec3 d = p-vec3(0.0, -26.0, 0.0);",
      
      "float phi = atan(d.x, d.y);",
      "float y = length(d.xy);",
      "vec3 pos = vec3(phi, y, d.z);",
      
      "pos = rotateY(pos, time);",
      "pos = rotateZ(pos, time);",

      "pos.x = repeat(pos.x, 8.0);",
      "pos.y = repeat(pos.y, 5.0);",
      
      "float kaari = box(pos, vec3(1.));",
      "return kaari;",
    "}",

    "vec3 normals(vec3 p){",

      "vec3 eps = vec3(0.1/resolution.x, 0.0, 0.0);",
      "vec3 n = vec3(",
        "map(p+eps.xyy) - map(p-eps.xyy),",
        "map(p+eps.yxy) - map(p-eps.yxy),",
        "map(p+eps.yyx) - map(p-eps.yyx));",
      "return normalize(n);",
    "}",

    "float march(vec3 orig, vec3 dir, float far){",
      "float t = 0.0001;",
      "float step = 0.0;",
      
      "float omega = 1.2;",
      "float prev_radius = 0.0;",
      
      "float candidate_t = t;",
      "float candidate_error = 1000.0;",
      
      "float sg = sign(map(orig));",
      "for(int i = 0; i < 64; ++i){",
        "vec3 p = dir*t+orig;",
        "float sg_radius = sg*map(p);",
        "float radius = abs(sg_radius);",
        
        "bool fail = omega > 1.0 && (radius+prev_radius) < step;",
        "if(fail){",
          "step -= omega * step;",
          "omega = 1.0;",
        "}",
        "else{",
          "step = sg_radius*omega;",
        "}",
        "prev_radius = radius;",
        "float error = radius/t;",
        
        "if(!fail && error < candidate_error){",
          "candidate_t = t;",
          "candidate_error = error;",
        "}",

        "if(!fail && error < (0.1/resolution.x) || t > far){",
          "break;",
        "}",
        "t += step;",
      "}",
      "if(t > far){",
        "return far;",
      "}",
      "return candidate_t;",
    "}",

    "vec3 render(in vec3 orig, in vec3 dir, out vec3 n, out float t, in float far){",
      "t = march(orig, dir, far);",
      "vec3 p = t*dir+orig;",
      "if(t < far){",
        "n = normals(p);",
      "}",
      "return p;",
    "}",
    
    "vec3 palette( in float t, in vec3 a, in vec3 b, in vec3 c, in vec3 d ){",
      "return a + b*cos( 6.28318*(c*t+d) );",
    "}",

    "vec3 shading(vec3 n, vec3 ld, vec3 dir){",
      
      "float t = dot(n,ld);",
      "vec3 a = vec3(0.5);",
      "vec3 b = vec3(0.5);",
      "vec3 c = vec3(2.0, 1.0, 0.0);",
      "vec3 d = vec3(0.5, 0.20, 0.25);",
      "vec3 emissive = vec3(0.7, 0.7, 1.0);",
      "if(phase > 0.){",
        "emissive = vec3(1.)-palette(t, a, b, c, d);",
      "}",
      
      //ambient + lambertian*diffuse + spec*specular
      "vec3 col = (AMBIENT + max(0.0, dot(n,ld))*DIFFUSE + ",
        "pow(max(dot(reflect(-ld, n), dir), 0.0), 20.0*0.25)*SPECULAR)*emissive;",
      "return col;",
    "}",


    "void main(){",
      "float FAR = 100.0;",
      "vec2 aspect = -1.0+2.0*(gl_FragCoord.xy.xy/resolution.xy);",
      "aspect.x *= resolution.x/resolution.y;",
        
      "vec3 target = vec3(0.0, 14.0, -1.0);",
      "vec3 orig = vec3(0.0, 12.0, 40.0);",
      
      "vec3 cw = normalize(target-orig);",
      "vec3 cu = normalize(cross(cw,vec3(0.0, 1.0,0.0)));",
      "vec3 cv = normalize(cross(cu,cw));",
      "mat3 camera = mat3(cu, cv, cw);",
      
      "vec3 dir = normalize(camera*vec3(aspect, 1.57));",
      "vec3 n = vec3(0.0);",
      "float t = FAR;",
      "vec3 p = render(orig, dir, n, t, FAR);",
      
      "vec3 sunDir = normalize(p-vec3(20.0, -20.0, 25.0));",
      "vec3 col = vec3(0.0);",
      "if(t < FAR){",
        "col = shading(n, sunDir, dir);",
        "col = pow(col, vec3(.8));",
        "col = smoothstep(0.25, 1.0, col);",
      "}",
      "gl_FragColor = vec4(col, 1.0);",
    "}",
  ].join("\n");
  
  return {
    uniforms : uniforms,
    vertexShader : vertexShader,
    fragmentShader : fragmentShader
  }
}