var Cubes = function(){
  PartBase.call(this);
  this.initScene();
}

Cubes.prototype = PartBase.prototype.inheritance();

Cubes.prototype.initScene = function(){
  PartBase.prototype.initScene.call(this);
  
  this.camera.position.set(0., 0., 200.);
  var pointLight = new THREE.PointLight(0xBF00FF);
  pointLight.position.set(0., 0., 80.);
  this.scene.add(pointLight);
  
  this.cubes = new THREE.Object3D();
  this.createCubes(60);
  
  this.scene.add(this.cubes);
  
  this.camSpeed = (-630-200)/(MUSIC.syncPoints.chorusStart-MUSIC.syncPoints.verse1Start);
}

Cubes.prototype.animate = function(timeStep, elapsedTime){
  PartBase.prototype.animate.call(this, timeStep, elapsedTime);
  this.cubes.rotation.z += timeStep; 
  this.camera.position.z = 200+this.camSpeed*(elapsedTime-this.startTime);
}

Cubes.prototype.createCubes = function(amount){
  var r = 40;
  var delta = 2*Math.PI/amount;
  var alpha = 0;
  var deltaZ = 10;
  var z = 0;
  var material = new THREE.MeshPhongMaterial({
    color : 0x22228B,//0x525052,
    ambient : 0x304132,
    emissive : 0x7171C6,//0x855285,
    specular : 0x00008B,//0xFF55FF
  });
  this.cubes1 = new THREE.Object3D();
  for(var i = 0; i < amount; ++i){
   
    var cube = new THREE.Mesh(new THREE.BoxGeometry(20, 20, 20), material);
    
    cube.position.y = Math.sin(alpha)*r;
    cube.position.x = Math.cos(alpha)*r;
    cube.position.z = z
    this.cubes1.add(cube);
    
    if(i != 0){
      var cube2 = cube.clone();
      cube2.position.y = Math.sin(-alpha)*r;
      cube2.position.x = Math.cos(-alpha)*r;
      this.cubes1.add(cube2);
    }
    z -= deltaZ;
    alpha += delta;
  }
  this.cubes2 = this.cubes1.clone();
  this.cubes2.position.z = z;
  this.cubes2.rotation.y = Math.PI;
  
  this.cubes1.rotation.z = Math.PI/3;
  this.cubes2.rotation.z = -Math.PI/3;
  
  this.cubes.add(this.cubes1);
  this.cubes.add(this.cubes2);
}