/**
 * Paraguay collor correction pipe by rimina
 */

THREE.ParaguayColorCorrect = {

	uniforms: {

		"tDiffuse":   { type: "t", value: null },
		"brightness": { type: "f", value: 0 }

	},

	vertexShader: [

		"varying vec2 vUv;",

		"void main() {",

			"vUv = uv;",

			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",

		"}"

	].join("\n"),

	fragmentShader: [

		"uniform sampler2D tDiffuse;",
		"uniform float brightness;",

		"varying vec2 vUv;",

		"void main() {",
      "vec4 c = texture2D( tDiffuse, vUv );",
      
      //Luminosity
      "vec3 luma = vec3(.299, .587, .114);",
      "float v = dot(c.xyz, luma);",
      "c.xyz = vec3(v)*c.xyz;",
      
      //Gamma
      "c.xyz = pow(abs(c.xyz), vec3(.6));",
      
      //Brightness
      "c.rgb += brightness;",
      
      //Contrast
      //"c.xyz = smoothstep(0., .95, c.xyz);",
      
      "gl_FragColor = c;",
		"}"

	].join("\n")

};
