
uniform float time;
uniform vec3 mouse;
uniform vec3 resolution;

uniform vec3 CamPos;
uniform vec3 CamDir;
uniform float PosY;
uniform vec3 CamShake;
//uniform vec2 resolution;

// hash

float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

// noise

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
}

// map


vec4 map( in vec3 p )
{
	//altitude
	float d = -0.005 - p.y + sin(time) / 4.0;
	d=0.05-p.y;
	//wind
	vec3 q = p - vec3(-0.4,0.0,sin(time)/1500.0 - 0.5) * time*(0.1-0.0*p.x);
	 q = p - vec3(1.0,0.2,0.0) * time*-0.05+vec3 (0.0,-0.0,0.0);

	 float f;
	q*=5.8;
    f  = 0.5000*noise( q ); q = q*2.02;
    f += 0.2500*noise( q ); q = q*2.03;
    f += 0.1250*noise( q ); q = q*2.01;
    f += 0.0625*noise( q );
	//f=pow(f,1.2);
	//density
	d += 4.0 * f;

	d = clamp( d, 0.0, 1.0 );
	
	vec4 res = vec4( d );

	// diffuse is here actually
//	res.xyz = mix( 1.15*vec3(1.0,0.95,0.8), vec3(0.7,0.7,0.7), res.x );
	res.xyz = mix( 1.1*vec3(1.0,1.1,1.2), vec3(0.7,0.7,0.7), res.x );
	
	return res;
}

// sundir

vec3 sundir = vec3(-1.0,-1.0,0.0);

// raymarch
float steps=0.0;

vec4 raymarch( in vec3 ro, in vec3 rd )
{
	vec4 sum = vec4(0, 0, 0, 0);
		//ro.xy+=CamPos.xy*10.0;
//if (time<154)	ro.x-=CamPos.z;
	float t = 0.0;
	for(int i=0; i<11; i++)
	{
		
		if( sum.a > 0.99 ) continue;
		steps+=0.1;
		vec3 pos = ro + t*rd;
		vec4 col = map( pos );
		
		#if 1
		float dif =  clamp((col.w - map(pos+0.3*sundir).w)/0.6, 0.0, 1.0 );
		float constrast = 0.5;
		//fake for now, but will change soon
		vec3 skylighting = vec3(0.4,0.48,1.2)*0.1 + 0.0 ;
		vec3 sunlighting = vec3(1.0,1.0,1.0)*0.7 + 0.0;
    
		
		vec3 lin = sunlighting + skylighting;
		col.xyz *= lin;
		col.xyz *= pow(col.xyz, vec3(constrast));
		#endif
		
		col.a *= 0.25;
		col.rgb *= col.a;

		sum = sum + col*(1.0 - sum.a);	

        #if 0
		t += 0.1;
		#else
		t += max(0.1,0.02*t)*1.0;
		#endif
	}

	sum.xyz /= (0.001+sum.w);

	return clamp( sum, 0.0, 1.0 );
}

vec2 UV;
void main( void ) {
	
	vec2 _resolution=vec2 (600)*1.5;
	//1920.0,1280.0);
	_resolution.x*=resolution.x/1280.0;
	_resolution.y*=resolution.y/720.0;
	//_resolution=resolution;

	vec2 glFragCoord=gl_FragCoord.xy;

	glFragCoord.xy+=CamShake.xy*300.0;
	vec2 q = glFragCoord.xy/ _resolution.xy;
	UV=q;
	vec2 p = -1.0 + 2.0*q;
	p.x *= _resolution.x/ _resolution.y;
	vec2 mo = -1.0 + 2.0 / _resolution.xy;
	
	    // camera
    	vec3 ro = 4.0*normalize(vec3(cos(4.00-1.5*mo.x), 0.7+(mo.y+1.0), sin(2.75-3.0*mo.x)));
    	 ro = 2.2*normalize(vec3(mo.x+2.0, (mo.y+5), 4.0*mo.x));

		
		vec3 ta = vec3(0.0, 0.0, 1.0);
    	vec3 ww = normalize( ta - ro);
    	vec3 uu = normalize(cross( vec3(0.0,1.0,0.0), ww ));
    	vec3 vv = normalize(cross(ww,uu));
    	vec3 rd = normalize( p.x*uu*1.0 + p.y*vv*1.0 + 1.0*ww );
	
	vec4 res = raymarch( ro, rd );

	float sun = clamp( dot(sundir,rd), 0.0, 1.0 );
	vec3 col = vec3(0.6,0.63,0.7) - rd.y*0.2*vec3(0.5,0.5,1.0) + 0.1 * 0.8;
	col += vec3(0.1,0.7,1.2)*sun * 0.6;

	col *= 0.95;
	
	col = mix( col, res.xyz, res.w );
	
	col += 0.3*vec3(0.13,0.7,0.9)*pow( 0.5+sun, 1.0 );

	float fcs=clamp ((time-158)*0.6,0.0,1.0)*3.14159;
//	float fcs=clamp ((time-98)*0.3,0.0,1.0)*3.14159;
	fcs=sin(fcs)*1.3;
	fcs=clamp (fcs,0.0,1.0);
	//col+=fcs*vec3 (0.7,0.3,0.2)*0.3;

	
	//col += 0.4*vec3(0.4,0.4,0.4)*pow( 1.0-sun, 1.0 );
	col *= col;
	col = col;
	float cc=col;
	gl_FragColor = vec4( col, 1.0 );

	float fc=1.0-clamp (1.4*(steps-5.3),0.0,1.0);
	fc+=0.0;
	//fc=0.3;
fc=1.0;
if (steps<6.0) 
	fc=0.0;
fc=1.0-q.y-0.44;
fc=q.y-0.44;



fc=clamp (fc,0.0,1.0);

fc=1.0-1.0*pow(1.0-fc-gl_FragColor.x*0.5,1.0);


//gl_FragColor.xyz*=gl_FragColor.xyz;
//fc=1;
float fcc=0.15*0.6;
fcc=0.15*0.7*clamp ((time-0)*0.3,0.0,1.0);
//fcc+=0.2*clamp ((time-4)*0.5,0.0,1.0);

//+clamp ((time-0*3.0)*0.2,0.0,1.0);
fcc=clamp (fcc,0.0,1.0);
//gl_FragColor=vec4 (gl_FragColor.x*4.0);
//gl_FragColor*=gl_FragColor;
//gl_FragColor*=gl_FragColor;
//fcc=1.0;
//fc=1.0;
gl_FragColor.w=fc*3.5*fcc*(1+gl_FragColor.x*0.5);
//_FragColor.xyz*=vec3 (1.7,1.0,1.0);
gl_FragColor.w*=(pow (UV.y,1.0));
float fsun=1.0-length (vec2 (1.0-UV.x,1.0-UV.y));
fsun=clamp (fsun,0.0,1.0);
fsun=1.3*pow(fsun,9.0);
float time2=time*0.7;
//gl_FragColor.xyzw+=vec4 (4.8,0.4,0.2,1.0)*fsun;
//gl_FragColor.xyzw+=(vec4 (0.8,0.3,0.1,1.0)-gl_FragColor.xyzw)*clamp (fsun,0.0,1.0);
gl_FragColor.xyzw+=vec4 (0.6,0.8,1.1,4.0)*fsun*(1.0-clamp ((time-73)*0.3,0.0,1.0));
float fsin=0.5+0.5*sin (UV.x*32.0-UV.y*1.3*16.5+time2*2.1);
fsin+=0.5+0.5*sin (UV.x*64.0-UV.y*1.2*32-time2*2.2);
fsin+=0.5+0.5*sin (UV.x*16.0-UV.y*0.7*8+time2*1.0);
fsin+=0.5+0.5*sin (UV.x*22.0-UV.y*1.2*11-time2*1.25);
fsin *=clamp (0.5+0.9*sin (UV.x*0.25*16.0-UV.y*0.25*0.7*8+time2*0.43),0.8,1.3);
//fsin *=clamp (0.5+0.9*sin (0+UV.x*0.17*16.0-UV.y*0.17*0.7*8+2-time2*0.51),0.7,10.0);
fsin*=0.33*cc*cc;

fsin=pow(fsin,3.0)*35.0*UV.y*UV.x;
//fsin+=pow(fsin,1.0)*10.0*UV.x;

fsin*=1.0-clamp ((time-79)*0.15,0.0,1.0);
//*cc;
gl_FragColor.xyzw+=vec4 (2.5,1.8,0.7,1.0)*1.05*fsin;
gl_FragColor.xyzw*=1.1;

gl_FragColor.w*=clamp ((time-0.8)*0.2,0.0,1.0);
//	.6,0.8,1.1,4.0)*fsun*(1.0-clamp ((time-73)*0.3,0.0,1.0));

gl_FragColor*=1.0-clamp ((time-(90))*0.14,0.0,1.0);
gl_FragColor+=(gl_FragColor*vec4 (0.4,0.7,1.2,1.1)*1.25-gl_FragColor)*clamp ((time-89)*0.2,0.0,1.0);


float fxx=clamp ((time-4.0)*0.2,0.0,1.0);
fxx-=0.5*clamp ((time-81.0)*0.3,0.0,1.0);
fxx+=0.5*clamp ((time-87.0)*0.17,0.0,1.0);
	gl_FragColor.xyz+=(gl_FragColor.xxx-gl_FragColor.xyz)*(1.0-fxx);



  //gl_FragColor.xyz+=(gl_FragColor.yyy-gl_FragColor.xyz)*1;
  //0.9*(1.0-clamp ((time-0.5)*0.3,0.0,1.0));


//gl_FragColor.w=clamp (1.0-steps*0.1,0.0,1.0);
}