#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;

//uniform image2D destTexPos;
//uniform image2D destTexCol;
float   hash(float v);
vec2    rhash(vec2 uv);

layout (binding=0) writeonly uniform image2D destTexPos;
layout (binding=1) writeonly uniform image2D destTexVel;
layout (binding=2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture; 
uniform sampler2D ColorTexture; 
uniform sampler3D CurlTexture; 

uniform sampler2D DepthTexture; 
uniform sampler2D SplineTexture;
//OutputDepthTexture; 

uniform sampler2D OriginalPositionTexture; 
uniform sampler2D OriginalColorTexture; 


uniform sampler2D OriginalPositionTexture_Fish;
uniform sampler2D OriginalPositionTexture_Text; 
uniform sampler2D OriginalColorTexture_Text; 

uniform sampler2D Swirl_Texture;


uniform sampler1D Original1DTexture;
layout (local_size_x = 16, local_size_y = 16) in;

layout (std140, binding=4) buffer Pos { vec4 Positions[]; }; 
layout (std140, binding=5) buffer Vel { vec4 Velocities[]; }; 
layout (std140, binding=6) buffer Col { vec4 Colors[]; }; 


const float InverseMaxInt = 1.0 / 4294967295.0;

float hash(float v)
{
	return fract(fract(v/1e4)*v-1e6);
}

vec2 rhash(vec2 uv) {
	const mat2 t = mat2(.12121212,.13131313,-.13131313,.12121212);
	const vec2 s = vec2(1e4, 1e6);
	uv *= t;
	uv *= s;
	return  fract(fract(uv/s)*uv);
}



float voronoi(const in vec2 uv)
{
	vec2 p = floor(uv);
	vec2 f = fract(uv);
	float v = 0.;
	for( int j=-1; j<=1; j++ )
		for( int i=-1; i<=1; i++ )
		{
			vec2 b = vec2(i, j);
			vec2 r = b - f + rhash(p + b);
			v += 1./pow(dot(r,r),8.);
		}
		return pow(1./v, 0.0625);
}




vec3 Rotate (vec3 Input, mat4 RotationM) { 
	vec4 Inn=Input.xyzz;
	Inn.w=1.0;
	Inn=RotationM*Inn;

	float fc=1.0-clamp (pow (length (Input)*1.1,1.0)+0.0,0.3,1.0);
	fc=0.4+0.4*sin(1*length (Input)+ttime);
	fc*=clamp ((ttime-100)*0.5,0.0,1.0);
	fc=0;
	Inn.xyz+=(Input-Inn.xyz)*fc;

	return Inn.xyz;

};





float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed,1.0)-0.5;
	float y=randhash (seed+413,1.0)-0.5;
	float z=randhash (seed*2+12,1.0)-0.5;
	return vec3(x,y,z);

};

vec3 GetCurl (vec3 Pos) { 

	return texture (CurlTexture,Pos.xyz).xyz;
};



float Octave (vec2 UV) { 
	float ff=0.5;
	float fv=int (UV.x*ff*20)/(ff*20.0);
	float fvy=int (UV.y*ff*40)/(ff*40.0);
	fv=0;
	fvy=0;
	float fy=voronoi (13*vec2(-fv+UV.x+ttime*0.073,fvy+UV.y+ttime*0.03+ttime*0.0));
	fy*=voronoi (11*vec2(UV.x-ttime*0.053,fvy+UV.y-ttime*0.02+ttime*0.0));
	// fy+=sin(voronoi (6*vec2(UV.x+ttime*0.073,UV.y-ttime*0.02+ttime*0.0)));
	fy+=(voronoi (10.4*vec2(UV.x-ttime*0.043,fv+UV.y-ttime*0.023+ttime*0.0)));

	fy*=1*voronoi (4*vec2(UV.x-ttime*0.043,fvy+UV.y+ttime*0.0+ttime*0.0));
	fy+=1.4*voronoi (33.4*vec2(fv+UV.x-ttime*0.042,UV.y+fvy-ttime*0.01+ttime*0.0))		*voronoi (6.4*vec2(fv+UV.x-ttime*0.033,UV.y+fvy-ttime*0.03+ttime*0.0))
		;

	fy+=0.3*sin(ttime+15.0*length (vec2 (1.0,0.2)*(UV-vec2 (0.5))));
	//fy=0.5+0.5*sin(fy*2);

	// fy*=0.5;
	//fy=voronoi (vec2(UV.x,UV.y)*8.0)*0.0;
	return fy;



};



float Octave2(vec2 UV) { 
	float ff=0.5;
	float fv=int (UV.x*ff*20)/(ff*20.0);
	float fvy=int (UV.y*ff*40)/(ff*40.0);
	fv=0;
	fvy=0;
	UV.y*=0.6;
	float fy=voronoi (13*vec2(-fv+UV.x+ttime*1.043,fvy+UV.y+ttime*0.03+ttime*0.0));
	fy*=voronoi (11*vec2(UV.x+ttime*0.043,fvy+UV.y-ttime*0.02+ttime*0.0));
	fy+=voronoi (6*vec2(UV.x+ttime*0.143,UV.y-ttime*0.02+ttime*0.0));
	fy+=voronoi (10.4*vec2(UV.x+ttime*0.043,fv+UV.y-ttime*0.02+ttime*0.0));
	fy+=1.4*voronoi (6.4*vec2(fv+UV.x+ttime*0.053,UV.y+fvy-ttime*0.01+ttime*0.0))
		*voronoi (6.4*vec2(fv+UV.x+ttime*0.033,UV.y+fvy-ttime*0.03+ttime*0.0))
		;

	fy*=voronoi (4*vec2(UV.x-ttime*0.223,fvy+UV.y-ttime*0.01+ttime*0.0));
	fy+=0.3*sin(ttime+15.0*length (vec2 (1.0,0.0)*(UV-vec2 (0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};



#define INVOCATION_SIZE (1536)
void main() {

	float TotalParticles=1.0/float(1536*1536);

	uint MyIndex=gl_GlobalInvocationID.x+gl_GlobalInvocationID.y*INVOCATION_SIZE;
	float fMyIndex=float(MyIndex);
	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
	float fMyIndexX=float(gl_GlobalInvocationID.x)*1.0/1536.0;
	float fMyIndexY=float(gl_GlobalInvocationID.y)*1.0/1536.0;

	vec2 fMyIndexXY=vec2 (fMyIndexX,fMyIndexY);

	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime*0.01)+0.01*Positions[MyIndex].xyz)*10.0*DeltaT;


	vec3 OriginalPos;
//	=1.0*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	OriginalPos.xyz=randhash3 (MyIndex)*5.0;


	vec3 FishPos=texture (OriginalPositionTexture_Fish,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;


	
	vec2 DUV;
	

	float original_depth;
	




	if (MyIndex>1512999) OriginalPos.z=1000.0;

	
	OriginalPos.y=(1-DUV.x)*4-2;
	OriginalPos.x=(DUV.y*4-2)*12.0/9.0;
	OriginalPos.xy*=4.0;
	





	//MyIndex+=int(ttime*100);






			OriginalPos.xy=texture (SplineTexture,vec2 (1.0,1)*vec2(storePos.x,storePos.y)*(1.0/1536.0)).xy;
			OriginalPos.xyz=randhash3 (MyIndex).xyz*33.0;
			//OriginalPos.y*=0.4;
			//OriginalPos.y+=3.5;

			//texture (SplineTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
			//OriginalPos.z=0;

			//OriginalPos.z+=50*PosY;

//			OriginalPos.x+=100*ttime;


//OriginalPos.z+=0.2*sin(ttime*1.0);
vec3 Disturb=GetCurl (vec3 (-ttime*0.0000)+0.06*Positions[MyIndex].xyz)*0.3+vec3 (0.0,0.0,0.0);
	Disturb+=GetCurl (vec3 (ttime*0.00000)+0.01453*Positions[MyIndex].xyz)*0.4;
	Disturb*=1;
	//Disturb.xyz+=OriginalPos.xyz*vec3 (1,1,1)*1.0;
		//Disturb.xyz+=vec3 (0,3,0);
		//OriginalPos.x+=0;	



		
		Colors[MyIndex].xyz=vec3 (1.0);;
		float _PosY=0.5;
		if (ttime<0.2) _PosY=-100.0;
		else
		_PosY=100.0;

//_PosY=PosY;
		float fc=_PosY+pow(0.0+1.0*sin (fMyIndex*0.00005+0.1*ttime),1.0);
	if (ttime<0.2)
		fc=0;
	else
		fc=1;
	fc=clamp (fc,0.0,1.0);
		fc=1-fc;
		//if (fc>0.7) fc=1.0;
		Colors[MyIndex].w=(1.0);
		
		Colors[MyIndex].xyz=(vec3 (original_depth)*0.00006);
		Colors[MyIndex].xyz=(vec3 (1.0));;
		//fc=clamp (PosY,0.0,1.0);


		Positions[MyIndex].xyz+=Disturb*DeltaT;
		Positions[MyIndex].xyz+=(OriginalPos-Positions[MyIndex].xyz)*fc;
		Positions[MyIndex].z+=+2.2*1.2*DeltaT*(0.3+randhash (MyIndex*5,1.0));
		
		
		if (Positions[MyIndex].z>10.0) Positions[MyIndex].z-=10*4.0;
		
		if (MyIndex>1*65535) { 

		Positions[MyIndex].xyz=vec3 (-1000);
		//Positions[MyIndex].xyz=FishPos*0.2;
		}

		//	Positions[MyIndex].xyz=vec3 (-1000);
		
		//Positions[MyIndex].xyz=randhash3 (MyIndex).xyz*8.0;

		Positions[MyIndex].w=1.0;

		//if (MyIndex%1131<20)			Colors[MyIndex].xyz*=vec3 (1.0,0.5,0.0);
		
		Positions[MyIndex].w=1-fc;
		Positions[MyIndex].w=1;

		Positions[MyIndex].w=clamp (	Positions[MyIndex].w,0.0,1.0);


		imageStore(destTexPos, storePos, Positions[MyIndex]);
		imageStore(destTexVel, storePos, Velocities[MyIndex]);
		imageStore(destTexCol, storePos, Colors[MyIndex]);
}
