//#version 110
#define float4 vec4
#define float3 vec3
#define float2 vec2
#define oUV gl_TexCoord[0]
#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D

varying vec3 normal;
varying vec4 normal2;
//varying vec4 position;
varying vec4 projection_position;
varying vec4 ShadowPosZ;
varying vec4 Color;

varying vec4 projection_from_camera;

varying vec2 UVcoordinates;
uniform vec4 Plane1;
uniform vec4 Plane2;
uniform vec4 Plane3;
uniform vec4 Plane4;
// Position of vertex in world space before rotation
varying vec4 Position_Pre;
uniform float ttime;

uniform mat4 ProjectionMatrix;


	uniform float PosY;

const float InverseMaxInt = 1.0 / 4294967295.0;


float randhash(uint seed, float b)
{
    uint i=(seed^12345391u)*2654435769u;
    i^=(i<<6u)^(i>>26u);
    i*=2654435769u;
    i+=(i<<5u)^(i>>12u);
    return float(b * i) * InverseMaxInt;
}



void main (void) 
{



	float4 nnormal= (normal2.xyzz);
// calculate ambient
float4 Ambient_Color=vec4 (0.2);

// calculate diffuse color
vec3 normalized_normal=normalize(normal2.xyz+normal.xyz);
float dott=dot(normalized_normal.xyz,vec3 (1.0,0.3,0.0));
dott=clamp (dott,0.0,1.0);
float4 Diffuse_Color=vec4 (dott);
//*vec4 (0.3,0.6,1.0,1.0);

// ca


// combine all
vec4 Final_Color=Ambient_Color*0.2+Diffuse_Color*0.4;


float4 TheNormal=(nnormal.xyzz+float4 (1.0))*0.5;
//TheNormal.w=shadow;
TheNormal.w=1.0;


//Final_Color=Diffuse_Color*Color;
Final_Color+=(TheNormal-Final_Color)*0.02;
//Final_Color=vec4 (1.0,1.0,0.0,1.0);
//Final_Color=TheNormal;


vec3 nnorm=normal;
nnorm.x=abs (nnorm.x);
nnorm.y=abs (nnorm.y);
nnorm.z=abs (nnorm.z);
float add=0.0;

if ((nnorm.x>nnorm.y) && (nnorm.x>nnorm.z)) { 
	nnorm/=nnorm.x;
add=1.0;
}

if ((nnorm.y>nnorm.z) && (nnorm.y>nnorm.x)) { 
	nnorm/=nnorm.y;
add=1.0;
}

if ((nnorm.z>nnorm.x) && (nnorm.z>nnorm.y)) { 
	nnorm/=nnorm.z;
add=1.0;
}




float resolution=140.0;

nnorm.x=pow (abs(nnorm.x),10.0);
nnorm.y=pow (abs(nnorm.y),10.0);
nnorm.z=pow (abs(nnorm.z),10.0);




int rx1=int ((projection_position.x+projection_position.y)*resolution/3.1415926);
float rh1=randhash (uint(rx1),1.0);
rh1=pow(clamp (1.0*sin(rh1*1.0*ttime),0.0,1.0),40.0);
rh1=1+30*rh1;

int rx2=int ((projection_position.x)*resolution/3.1415926);
float rh2=randhash (rx2,1.0);
rh2=pow(clamp (1.0*sin(rh2*1.0*ttime),0.0,1.0),40.0);
rh2=1+30*rh2;

int rx3=int ((projection_position.y+projection_position.z)*resolution/3.1415926);
float rh3=randhash (rx3,1.0);
rh3=pow(clamp (1.0*sin(rh3*1.0*ttime),0.0,1.0),40.0);
rh3=1+30*rh3;

Final_Color*=1.0+0.2*
clamp (

pow (rh3*sin((projection_position.y+projection_position.z)*nnorm.x*resolution),10.0)
	   



+pow(rh2*sin((projection_position.x)*nnorm.y*resolution),10.0)


							   +rh1*sin((projection_position.x+projection_position.y)*nnorm.z*resolution)
							   ,0.0,1000.0);
float fc=1.0-clamp (ttime*0.1,0.0,1.0);

if (Final_Color.x<fc) discard;


//if (sin(projection_position.x*50.3)*cos(projection_position.y*50.3)>0.7) discard;

//if (sin((projection_position.y+projection_position.z)*nnorm.x*100.0)<0.5) discard;

if (projection_position.z >0.0) discard;




gl_FragData[0]=TheNormal;
//Final_Color.w=1.0;


Final_Color.w=1.0;
gl_FragData[1]=Final_Color*1.0;

// Depth fragment 
///gl_FragDepth=gl_FragCoord.z+0.02*ftex;
}














