#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;
uniform float alltime;

//uniform image2D destTexPos;
//uniform image2D destTexCol;

layout (binding=0) writeonly uniform image2D destTexPos;
//layout (binding=1) writeonly uniform image2D destTexVel;
layout (binding=2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture; 
//uniform sampler2D ColorTexture; 
uniform sampler3D CurlTexture; 

uniform sampler2D OriginalPositionTexture; 
uniform sampler2D OriginalColorTexture; 
uniform sampler2D OriginalPositionTexture_Monolith; 
uniform sampler2D OriginalPositionTexture_Fish; 
uniform sampler2D OriginalPositionTexture_Bird; 


uniform mat4 RotationMatrix;
uniform mat4 RotationMatrix3;
uniform mat4 RotationMatrix4;

layout (local_size_x = 16, local_size_y = 16) in;

layout (std140, binding=4) buffer Pos { vec4 Positions[]; }; 
//layout (std140, binding=5) buffer Vel { vec4 Velocities[]; }; 
layout (std140, binding=6) buffer Col { vec4 Colors[]; }; 
float breaktime=18.0;

const float InverseMaxInt = 1.0 / 4294967295.0;



uint MyIndex=0;




vec3 Rotate (vec3 Input, mat4 RotationM) { 
	vec4 Inn=Input.xyzz;
	Inn.w=1.0;
	Inn=RotationM*Inn;

	float fc=1.0-clamp (pow (length (Input)*1.1,1.0)+0.0,0.3,1.0);
	fc=0.4+0.4*sin(1*length (Input)+ttime);
	fc*=clamp ((ttime-100)*0.5,0.0,1.0);
	fc=0;
	Inn.xyz+=(Input-Inn.xyz)*fc;

	return Inn.xyz;

};











float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed,1.0)-0.5;
	float y=randhash (seed+413,1.0)-0.5;
	float z=randhash (seed*2+12,1.0)-0.5;
	return vec3(x,y,z);

};

vec3 GetCurl (vec3 Pos) { 

	return texture (CurlTexture,vec3 (-2.5)+Pos.xyz).xyz;
};







#define INVOCATION_SIZE (1536)
void main() {





	MyIndex=gl_GlobalInvocationID.x+gl_GlobalInvocationID.y*INVOCATION_SIZE;

	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);



	float _PosY=(ttime-5.0);
	_PosY=clamp (_PosY,0.0,10.0);
	_PosY=PosY;

	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime*0.01)+0.01*Positions[MyIndex].xyz)*10.0*DeltaT;

	vec3 OriginalPos=0.5*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	vec4 OrPos=OriginalPos.xyzz;
	OrPos.w=1.0;

	//OrPos=(RotationMatrix*OrPos);


	OrPos=(RotationMatrix*OrPos);
	OriginalPos.xyz=OrPos.xyz;
	OriginalPos.x*=1.1;
	//OriginalPos.y+=PosY;

	float original_posy=OriginalPos.y;

	OriginalPos.y+=0.9;
	//OriginalPos.y+=ttime*2.0;

	//OriginalPos.y-=3.5;
	//OriginalPos.xyz=vec3 (0,6.0,0);
	float fc;

	fc=clamp (sin(_PosY+float (MyIndex)*0.001),0.0,1.0);


	vec3 Disturb=GetCurl (vec3 (ttime*0.00)+0.16*Positions[MyIndex].xyz)*0.5*DeltaT;
	Disturb+=GetCurl (vec3 (ttime*0.01)+0.11*Positions[MyIndex].xyz)*0.5*DeltaT;
	Disturb+=vec3 (0.0,2.5*pow(1.1*randhash (MyIndex*22,1.0),4.0),0.0)*DeltaT*0.3;



	//Disturb.xz+=( (OriginalPos).xz-Positions[MyIndex].xz)*DeltaT*10.0;

	//Disturb+=vec3 (0.0, randhash(MyIndex*12,1.0)*clamp ((ttime-3.0),0.0,1000.0)*-2.0,0.0)*DeltaT*0.3;
	//	Disturb=vec3 (0.0,0.1,0.0);

	//if (MyIndex%10==0)	 Disturb+=vec3 (0.0,0.05*randhash ( MyIndex*42,1.0),0.0)*DeltaT;

	//if (MyIndex%70==0)	Disturb=vec3 (0.0,2.5*randhash (MyIndex*22,1.0),0.0)*DeltaT*2.0;



	//+vec3 (0.0,0.3,0.0)*DeltaT;
	//	+vec3 (-1.0,0.0,0.0)*DeltaT;
	//if (MyIndex%20==0)	 Disturb=GetCurl (vec3 (ttime*0.00)+0.15*Positions[MyIndex].xyz)*1.0*DeltaT+vec3 (0.0,0.0,0.0)*DeltaT;

	//Disturb=GetCurl (vec3 (ttime*0.00)+0.15*Positions[MyIndex].xyz)*1.0*DeltaT+OriginalPos.xyz*DeltaT;

	//fc=1.0;




	//Colors[MyIndex].xyz=texture2D (OriginalColorTexture,vec2(storePos.x,storePos.y)*(1.0/1024.0)).xyz;




	vec3 FlatPosition=randhash3(MyIndex);
	float theta=100.0*randhash (MyIndex,1.0);
	FlatPosition.xyz=vec3(sin(theta),0.0,cos(theta))*15.0*randhash(uint(MyIndex*17+3),1.0);
	FlatPosition.y=0.0;


	float _ftime=ttime*0.2;
	_ftime=clamp (ttime*1.0-1.0,0.0,80.0);
	float fi;
	fi=clamp ((_ftime-12.8)*0.65-original_posy*2.0,0.0,1.0);


	if (ttime>breaktime) 
	{

		if (MyIndex%70000<58000)		 fi=0.0; else fi=1.0;

	}

	FlatPosition.xz+=(OriginalPos.xz-FlatPosition.xz)*fi;
	FlatPosition.y+=(OriginalPos.y-FlatPosition.y)*pow (fi,90.0);
	Colors[MyIndex].x=0;


	float recl;
	vec3 OldDisturb=Disturb;
	float rff=randhash (MyIndex*5,1.0);
	if ((ttime<breaktime)	&& (rff<0.99))
	{
		Disturb*=0.0;
		Colors[MyIndex].x=clamp ((ttime-4.0)*0.1,0.0,1.0)*0.2;
	}

	else
	{
		Colors[MyIndex].x=clamp ((ttime-3.0)*0.1,0.0,1.0)*randhash (MyIndex,1.0)*1.0;
		//fi=0.0;

	}


	Colors[MyIndex].x+=(0.1-Colors[MyIndex].x)*fi;


	vec3 LastPos=Positions[MyIndex].xyz;



	if (ttime<1.0) 
		recl=1.0;
	else
		recl=0.0;

	recl+=fi;

	Colors[MyIndex].z=0.0;

	if (ttime>breaktime) {
		Disturb=0.0*OldDisturb;

		float randxx=randhash (MyIndex+4,1.0);

		Disturb=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.0,0.0)+0.13*Positions[MyIndex].xyz)*1.0*DeltaT;
		Disturb+=GetCurl (vec3 (ttime*0.00)+0.10*Positions[MyIndex].xyz)*0.2*DeltaT;
		//Disturb+=vec3 (0.0,2.5*randhash (MyIndex*22,1.0),0.0)*DeltaT*1.0;
		//Disturb.y=abs (Disturb.y);
		vec3 Direction=Positions[MyIndex].xyz;
		Disturb.xyz+=normalize(Direction)*DeltaT*6.0*vec3 (1.0,0.0,1.0);
		Disturb.xyz+=vec3 (0.0,1.0,-1.0)*DeltaT;
		//Direction=normalize (Direction)*randhash (MyIndex*4,1.0);
		if (MyIndex%10<3)
			Disturb.y+=4.4*randhash (MyIndex*14,1.0)*DeltaT;

		//if (MyIndex%10000<5000) 		Positions[MyIndex].y=10.0;


		if (ttime>34) { 

			Disturb=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.0,0.0)+0.13*Positions[MyIndex].xyz)*1.0*DeltaT;
			Disturb+=GetCurl (vec3 (ttime*0.00)+0.10*Positions[MyIndex].xyz)*0.2*DeltaT;

			float ftq=clamp ((ttime-40.0-float(MyIndex)*0.0)*1.0,0.0,1.0);

			Disturb.z+=(1.3-ftq)*4.4*randhash (MyIndex*14,1.0)*DeltaT;
			Disturb.z+=(1.3-ftq)*16.4*pow(randhash (MyIndex*22,1.0),8.0)*DeltaT;

			Disturb.z+=ftq*5.0*sin(1+ttime+float(MyIndex)*0.0000005)*DeltaT;
			Disturb.y+=0.8*DeltaT;


			//14.4*pow(randhash (MyIndex*22,1.0),4.0)*DeltaT;
			//Disturb.xyz+=vec3 (0,0,1)*DeltaT;
		};
		//sturb*=0.0;

		if (ttime>43+float(MyIndex)*0.000001){

			//Disturb.y+=0.7*pow(randhash (MyIndex*31,1.0)+0.0,4.0)*25.0*DeltaT;
			//	Disturb.y+=1.3*DeltaT;
			//Disturb.z-=0.7*pow(randhash (MyIndex*62,1.0)+0.0,4.0)*25.0*DeltaT;


		}




		float resist=1.0;

		/*
		if (MyIndex%10000<1670) { 
		//f (MyIndex%10<1)
		Disturb.xyz+=vec3 (0.0,randxx,0.0)*DeltaT*3.0;
		float randx2=pow(randxx,2.0);
		Disturb.xyz+=Direction*DeltaT*4.0*(1+1.5*randx2);
		//Disturb.y-=pow((ttime-15.7)*0.2,2.0);
		resist=0.0;
		if (MyIndex%5==0)
		resist=0.03;

		}

		*/
		Colors[MyIndex].y=0.0;

		Colors[MyIndex].x=1.3*(1.0-0.9*clamp (ttime-breaktime-0.4+float(MyIndex)*0.0000005,0.0,1.0));

		if (MyIndex%70000>40000)
			Colors[MyIndex].x=randhash (MyIndex,1.0)*0.6;
		/*if (ttime>breaktime+0.1 )
		if (MyIndex>950670) { 
		//f (MyIndex%10<1)
		Disturb.xyz+=vec3 (0.0,randxx,0.0)*DeltaT*1.0;
		float randx2=pow(randxx,2.0);
		Disturb.xyz+=Direction*DeltaT*4.0*(1+1.5*randx2);
		//Disturb.y-=pow((ttime-15.7)*0.2,2.0);
		resist=0.0;
		}
		*/



		/*
		if (ttime>18.3)
		if (MyIndex>980670) { 
		//f (MyIndex%10<1)
		Disturb.xyz-=vec3 (0.0,randxx,0.0)*DeltaT*3.0;
		float randx2=pow(randxx,2.0);
		Disturb.xyz+=Direction*DeltaT*2.0*(1+1.5*randx2);
		//Disturb.y-=pow((ttime-15.7)*0.2,2.0);
		resist=0.0;
		}

		*/

		//if (ttime>breaktime) 		 if (ttime<breaktime+0.2) 			 Disturb*=5.0;
		//if (ttime<16.9)	

		Disturb *=1.2;
		//Disturb.x+=DeltaT*4.0;


		recl=((sin(ttime*0.02+float (MyIndex)*0.00017)))*0.5+0.49*1.0;
		recl=clamp (recl,0.0,1.0);
		//recl=pow(recl,1.0);

		recl=recl*1.0;
		//recl=0.0;
		//if (MyIndex%10<8) recl=0.0;
		//recl=sin (ttime*0.1+float (MyIndex)*0.0001);
		//if (ttime<17.0) recl=1.0;
		fi=0.0;

		recl=clamp (recl,0.0,1.0);
		// recl*=1-0.7*clamp (sin(3.0*ttime+float (MyIndex)*0.000001),0.0,1.0);
		recl*=resist;
		recl*=1.0-clamp ((ttime-21.0-7+float(MyIndex)*0.000004+0.0*Positions[MyIndex].y)*1.5,0.0,1.0);

		recl+=(1.0-recl)*clamp (ttime-32.0-FlatPosition.z+float(MyIndex)*0.00000,0.0,1.0);
		//recl+=(1.0-recl)*clamp (ttime-33.0+length (Positions[MyIndex].xyz)+float(MyIndex)*0.000000,0.0,1.0);

		//if (ttime>35.0)
		//recl*=1.0-clamp ((ttime-34+float(MyIndex)*0.00001),0.0,1.0);


		//if (MyIndex%7000<3000) recl=1.0;

		//-1.0*clamp (recl,0.0,1.0);
		//FlatPosition=OriginalPos;
	}

	//recl=1.0;




	float appear=clamp (ttime*0.1,0.0,1.0);

	if (ttime>56.0+float(MyIndex)*0.000002)
	{


		Disturb=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.0,0.0)+0.18*Positions[MyIndex].xyz)*1.0*DeltaT;
		Disturb+=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.4,0.0)+0.11*Positions[MyIndex].xyz)*1.0*DeltaT;
		//Disturb.xz-=normalize (Positions[MyIndex].xz)*2.5*DeltaT;
		//Disturb+
		if ((ttime>120+float(MyIndex)*0.0000001) && (ttime<140+float(MyIndex)*0.0000003))
		{
			Disturb+=vec3 (0.0,0.0,20.0)*DeltaT;

			//if (ttime>129)		Disturb-=vec3 (0.0,0.0,13.0)*DeltaT;


		}

		else
			Disturb+=vec3 (0.0,2.0,0.0)*DeltaT;
if (ttime>168.0)
			Disturb+=vec3 (0.0,5.0,0.0)*DeltaT;



	}



	Positions[MyIndex].xyz+=Disturb*0.2*appear;
	//Colors[MyIndex].z=pow(1.0-recl,4.0);

	if (MyIndex%70000<15000)		 recl=0.0;	



	if (ttime>34.0) { 


		if (length ((FlatPosition.yx+vec2 (-0.9,0.0))*vec2 (0.4,1.0))<0.4)
		{
			recl=1-1*clamp (ttime-34.1-3+FlatPosition.y*0.25-FlatPosition.z*1.1-length (FlatPosition.zy-vec2 (0.0,1.0))*0.5,0.0,1.0);;	
			//	float recl2=1-1*clamp (ttime-36.0-3-FlatPosition.z*1.1,0.0,1.0);;	

			if (FlatPosition.y<0.2)
				Colors[MyIndex].x*=5.0-4.0*recl;
		}

		float fxx=0.5+0.3*sin(FlatPosition.x*3.0);
		fxx=1;




		if (length ((FlatPosition.yx+vec2 (-0.9,0.0))*vec2 (0.4,1.0))>0.8)
			if (sin(FlatPosition.x*15.0)+(1.0-clamp ((ttime-38-3-FlatPosition.z),0.0,1.0))<0.0)
			{
				float recl2=clamp (ttime-39.0-FlatPosition.z*0.0,0.0,1.0);;	


				recl=0.0;
				//if (FlatPosition.y<0.2)
				//		Colors[MyIndex].x*=(8-7*recl2);
			}


			//1.0-clamp (ttime-34.0-3-FlatPosition.z*1.1,0.0,1.0);;	



	};

	if (ttime>43.0+float(MyIndex)*0.000001) {

		recl=0.0;
	}
	float mitrecl=0;

	if (ttime>55.0+float(MyIndex)*0.000002)
	{
		recl=1.0;
		//				 clamp (ttime-52-float(MyIndex)*0.000001,0.0,1.0);
		//recl=clamp (recl,0.0,1.0);
		float fcc=clamp ((ttime-55.0-float(MyIndex)*0.000002)*0.1,0.0,1.0);
		recl+=(fcc*2.0*sin(ttime*0.04+float(MyIndex)*0.0002));
		// recl+=(fcc*0.3*sin(ttime*0.24+float(MyIndex)*0.00003));

		//	 recl+=2*clamp ((ttime-79)*0.2,0.0,1.0);;
		//if (ttime>60)
		recl-=2.0*sin(3.14159265*clamp((ttime-64-float(MyIndex)*0.000000)*0.7,0.0,1.0));;

		recl=clamp (recl,0.1,1.0);
		recl=1-recl;		 
		//recl+=length (Positions[MyIndex].xyz)*0.001;
		recl=clamp (recl,0.0,1.0);
		mitrecl=recl;
		FlatPosition=0.5*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).zyx;




		// sphere trans
		vec2 PhiTh=vec2 (storePos.x,storePos.y)*(1.0/1536.0);
		float sfth=PhiTh.x+PhiTh.y*1.0/1536.0;

		vec3 SpherePos=vec3 (2.0*sin (sfth*6.28+ttime),0,2.0*cos(sfth*6.28+ttime))*0.02;
		int ssc=int(clamp ((ttime-76)*10,0.0,10000.0));
		if (ttime>76) ssc+=200;
		if (ttime>80) ssc=5000;
		if (ttime>82.6) ssc=10000;
		if (ttime>86) ssc=10300;
		if (MyIndex%10320<ssc){
			float fsc=clamp ((ttime-85.0-float(MyIndex%5000)*0.0007)*0.4,0.0,0.98);
			SpherePos+=randhash3(MyIndex/ssc)*(6.0-6.0*fsc);

		}


		float fss=clamp ((ttime-70.0-FlatPosition.y*0.0-float(MyIndex)*0.000003)*0.6,0,1);
		//	  fss-=clamp ((ttime-95-FlatPosition.y*0-float(MyIndex)*0.000001)*2.6,0,1);

		//if (ttime>95)		 	FlatPosition=vec3 (0.0,.0,0.0)+vec3 (0.0,1.0,-1.0)*1.6*texture2D (OriginalPositionTexture_Monolith,vec2(storePos.x,storePos.y)*(1.0/1536.0)).zyx;


		FlatPosition+=(SpherePos-FlatPosition)*fss;



		vec4 OrPos=FlatPosition.xyzz;
		OrPos.w=1.0;


		OrPos=(RotationMatrix*OrPos);
		FlatPosition.xyz=OrPos.xyz;




		FlatPosition.y+=-(ttime-58)*0.1;

		bool pass=false;
		if (((MyIndex%54200)/13550)%2!=0) pass=true;

		if (ttime>80.0) pass=false;
		//if (((MyIndex%54200)/13550)%6!=0)
		if (pass)
		{
			
			
			
	//		FlatPosition=vec3 (0.0,-5.0+(ttime-58)*1.0,0.0)+randhash3 (MyIndex)*0.5*vec3 (5.0,40.0,8.0)+vec3 (0,0,-3);
			FlatPosition=vec3 (0.0,-9.0+(ttime-58)*1.0,0.0-1.84)+
			texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz
			*vec3 (4.0,3.0,1.0);
			
			
			
		//	FlatPosition.y-=25*pow(randhash (MyIndex*2,1.0),4.0);

			if (MyIndex%2==0)
				FlatPosition.z-=-3.24;

			if ((MyIndex/2)%2==0)
				FlatPosition.y-=10.0;

			//2.0+3*(1-clamp ((ttime-62)*0.2,0.0,1.0));

		//	Disturb=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.0,0.0)+0.18*Positions[MyIndex].xyz)*5.0*DeltaT;
		//Disturb+=GetCurl (vec3 (ttime*0.00)+vec3 (0.0,0.4,0.0)+0.02*0.11*Positions[MyIndex].xyz)*5.0*DeltaT;
			Disturb=vec3 (0.0,-2.0,0.0)*DeltaT;
				Positions[MyIndex].xyz+=Disturb*0.5;

//			OldDisturb=Disturb;

			recl=1.0-2.0*clamp ((ttime-64)*0.2,0.0,1.0)*1.0*pow (randhash (MyIndex,1.0),10.0);
			recl=clamp (recl,0.0,1.0);

			Colors[MyIndex].y=0.1;
			Colors[MyIndex].x=1.0*clamp ((ttime-63)*0.2,0.0,1.0)*1.0*pow (randhash (MyIndex,1.0),3.0);
			
			//recl=clamp (recl,0.0,1.0);
		}
		else
		{

			//			 if (recl<0.2)
			//	 if (recl>0.0)
			//Colors[MyIndex].y=-(1.0-recl)*0.53;
			if (ttime>68.0)
				if (recl<0.1)
					if (recl>0.05)
						Colors[MyIndex].y=1.1;


		}
		//if (((MyIndex%54200)/13550)%5==1) FlatPosition+=vec3 (0.0,0.0,2.0);
		//if (((MyIndex%54200)/13550)%5==2) FlatPosition+=vec3 (0.0,0.0,PosY);
		//if/ (((MyIndex%54200)/13550)%5==3) FlatPosition+=vec3 (0.0,0.0,0.0);


		//+=vec3 (110.0,0.0,2.0);
		//recl=1.0;

	}

	bool which3=false;

	//if (ttime<60+ Positions[MyIndex].z*2.0)
	if (ttime>94.0+float(MyIndex)*0.000002+Positions[MyIndex].y*0.0) 
	{ 



		//if (MyIndex%10<4)
		{ 
			float dist=(ttime-(94.0+float(MyIndex)*0.000002+Positions[MyIndex].y*0.0))*(pow(randhash (MyIndex,1.0),35.0)+0.3);
			dist=clamp (3.0*dist,0.0,1.0);
			dist=1.0;
			FlatPosition=0.2*texture(OriginalPositionTexture_Monolith,vec2(storePos.x,storePos.y)*(1.0/1536.0)).zyx;
			//vec3 Rotate (vec3 Input, mat4 RotationM) { 
			FlatPosition=Rotate (FlatPosition,RotationMatrix3);
			

			//NewFlatPosition=Rotate (NewFlatPosition,RotationMatrix);
			//NewFlatPosition=Rotate (NewFlatPosition,RotationMatrix);


			//recl=clamp ((ttime-46-float(MyIndex)*0.000001)*0.3,0.0,1.0);

			//Positions[MyIndex].w=0.3;
			//Colors[MyIndex].x*=1-recl;
			//Colors[MyIndex].y=recl*2.0;
			if (ttime>101.8) { 
				float dist=0.7+0.4*sin(ttime*1.5+float(MyIndex/1000)*0.0001);

				if (MyIndex%2==0){
					FlatPosition=Rotate (FlatPosition,RotationMatrix3);
					FlatPosition.z+=dist;

				}
				else
					FlatPosition.z-=dist;

				if (ttime>104.16) { 
					if ((MyIndex/2)%2==0){
						FlatPosition=Rotate (FlatPosition,RotationMatrix);
						FlatPosition.y+=dist;

					}
					else
						FlatPosition.y-=dist;
				}


				if (ttime>108.7) { 
					if ((MyIndex/4)%2==0){
						//FlatPosition=Rotate (FlatPosition,RotationMatrix3);
						FlatPosition.z+=2.0*dist;

					}
					else
						FlatPosition.z-=2.0*dist;
				}
			};



			//fish
			if (ttime>115.0+float (MyIndex/10000)*0.02) { 


				vec3	FlatPositionFish=vec3 (0.0,.0,0.0)+vec3 (1.0,1.0,-1.0)*0.4*texture (OriginalPositionTexture_Fish,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;

				float fliper=clamp (abs (FlatPositionFish.x*0.2)-0.1,0,1);

				FlatPositionFish.y+=fliper*sin(ttime*2.0-3.0*fliper)*6.0;

				float back=clamp ((FlatPositionFish.z*0.1)+0.45,0.0,1.0);
				FlatPositionFish.y+=back*back*cos(-1.0+ttime*3.0-12.0*back)*1.0;


				//FlatPositionFish=Rotate (FlatPositionFish,RotationMatrix);




				recl=clamp (recl+0.1,0.0,1.0);


				if (MyIndex%50<35) 		{
					FlatPosition=FlatPositionFish;
					which3=true;
				}
				else
					recl=0.02;



				Colors[MyIndex].x=3.0*pow(randhash (MyIndex,1.0),80.0);
				//	 Colors[MyIndex].z=1.0;
			};

			if (which3)
				if (ttime>125.0+float (MyIndex)*0.000003) 
				{
					recl=0.03;
					//Colors[MyIndex].x+=DeltaT*1.7;


				}


				//if (!which3)				 recl=0.04;


				//if (ttime<135)
				if (ttime>124.0+float(MyIndex)*0.000024)
				if (ttime<140.0+float(MyIndex)*0.000004)
					if (!which3) {

						{ 
							if (Positions[MyIndex].z>4) 
							{
							Positions[MyIndex].z-=7.0;
							//Colors[MyIndex].x=12.0;
							
							}
								//FlatPosition.z-=10;
						}



					}


					FlatPosition+=vec3 (0.0,2-1.0-(ttime-58.0)*0.1,0.0);

					//recl-=10.8*clamp ((ttime-105-float (MyIndex)*0.000001)*0.6,0.0,1.0);

					recl=clamp (recl,0.0,1.0);
		}
	}








		//monolith and last bird
	
	vec3	FlatPositionFishN=vec3 (0.0,.0,0.0)+vec3 (1.0,1.0,-1.0)*0.9*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	//FlatPositionFishN=0.5*texture2D (OriginalPositionTexture_Bird,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;

	// edw edw1
				//if (ttime>141.0)			FlatPositionFishN=Rotate (FlatPositionFishN,RotationMatrix4);

	float fddist=length (FlatPositionFishN.yxz)*4.0;
			if (ttime>143.0+float ((MyIndex/1000)%100)*0.00+1.0*fddist) { 


				vec3	FlatPositionFish=FlatPositionFishN;
				//vec3 (0.0,.0,0.0)+vec3 (1.0,1.0,-1.0)*0.9*texture2D (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
				FlatPositionFish=Rotate (FlatPositionFish,RotationMatrix3);
				if (MyIndex%16==0)
FlatPositionFish=randhash3 (MyIndex)*5.0+vec3 (0.0,(ttime-143.0)*0.1,0);



				float fliper=clamp (abs (FlatPositionFish.x*0.2)-0.1,0.0,1.0);

//				FlatPositionFish.y+=fliper*sin(ttime*2-3*fliper)*6;

				float back=clamp ((FlatPositionFish.z*0.1)+0.45,0.0,1.0);
//				FlatPositionFish.y+=back*back*cos(-1+ttime*3-12*back)*1;
				FlatPositionFish.y+=-2.0*4.0;
				//atPositionFish.z+=3;
				FlatPositionFish.y-=(ttime-143.0)*0.0;
				FlatPosition=FlatPositionFish;




				recl=clamp (recl+0.1,0.0,1.0);
				//cl=1.0;
				
				if (MyIndex%50<40) 		{
					FlatPosition=FlatPositionFish;
				recl=mitrecl;
				recl-=1.0*clamp (ttime-153.0-float(MyIndex)*0.000001,0.0,1.0);
				}
				

	vec3 FlatPositionBird=+0.5*texture (OriginalPositionTexture_Bird,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
		

		

				float wings=clamp (abs (FlatPositionBird.x*0.2)-0.06,0.0,1.0);
				FlatPositionBird+=vec3 (-1.7+2.0,-1.6*5.0+1.0,(ttime-152.0)*2.0+1.5);
				FlatPositionBird.y+=wings*(sin(ttime*2.0-3.0*wings)*3.0-1.0);
	
	float flx=(ttime-152.0-float(MyIndex)*0.0000001);
	flx=clamp (flx,0.0,1.0);

	float flx2=(ttime-156.0-float(MyIndex)*0.0000001);
	flx2=clamp (flx2,0.0,1.0);

	float flx3=(ttime-162.0-float(MyIndex)*0.000001);
	flx3=clamp (flx3,0.0,1.0);
	//x=1.0;
	FlatPosition+=(FlatPositionBird-FlatPosition)*flx;
	recl+=flx2*0.3;

				//recl=1.0;
				//else					recl=0.02;
	if (MyIndex%50<3) 		{
					//FlatPosition=FlatPositionFish;
						FlatPosition=randhash3(MyIndex)*vec3 (1.0,2.0,30.0);

	}

				recl=clamp (recl,0.0,1.0);

				Colors[MyIndex].x=5.0*pow(randhash (MyIndex,1.0),130.0)*(1-0.6*flx);

					if (MyIndex%500<8) 		{
					//FlatPosition=FlatPositionFish;
						FlatPosition=randhash3(MyIndex)*vec3 (1.0,2.5,60.0)+vec3 (0.0,-7.0,10.0);
						FlatPosition.y+=1.0*(0.5+randhash (MyIndex,1.0))*clamp(ttime-169,0.0,100.0);

						Colors[MyIndex].x=12.0;
	}

						else
							FlatPosition.y+=1.0*(0.5+randhash (MyIndex,1.0))*clamp(ttime-170.0,0.0,100.0);
				
				
				Colors[MyIndex].y=flx3*8.0;
			//fi=0;
			};





			if (ttime>138.0)			
			//if (ttime<141.0+4*3.1415926)			
				//if (MyIndex%2==0)
			{
				float fss=clamp ((ttime-138.0+float (MyIndex)*0.000001)*0.3,0.0,1.0);
			recl+=0.05*sin (fss*3.1415926535);
			recl=clamp (recl,0.0,1.0);
			FlatPosition=Rotate (FlatPosition,RotationMatrix4);
			if (MyIndex%1000<300)
			if (ttime>140.0)
				if (ttime<140.5)
					FlatPosition=randhash3 (uint(MyIndex/20000))*20.0;
			

			}


	//recl=1.0;





float fthe=+float (MyIndex)*0.0000002;
			
float fdsp=sin (1+0.5*2*3.1415926*alltime*100.0/60.0+1.3+fthe);
fdsp=clamp (fdsp,0.0,1.0);
fdsp=pow (fdsp,8.0);

if (ttime>99.8) 
if (ttime<125)
if (MyIndex%10<=2)
{ 
recl+=fdsp*0.8;
//*4.0*sin (float (MyIndex)*0.003);

}

recl=clamp (recl,0.0,1.0);



	Positions[MyIndex].xyz+=(FlatPosition-Positions[MyIndex].xyz)*recl;
	//Positions[MyIndex].xyz+=vec3 (1000.0);


	vec3 NowPos=Positions[MyIndex].xyz;
	if (ttime<48.0)
		Colors[MyIndex].y=0.0;

	Positions[MyIndex].w=int(fi*100.0);
	//	Positions[MyIndex].w+=(0.0+2.0*clamp (length (Disturb.xyz)/DeltaT*2.0,0.0,0.5))*clamp (ttime*0.1,0.0,1.0)*(1.0-fi);

	imageStore(destTexPos, storePos, Positions[MyIndex]);
	imageStore(destTexCol, storePos, Colors[MyIndex]);
}
