
#version 130

varying vec4 position;
uniform sampler2D PositionTexture; 
varying vec4 thecolor;
uniform sampler2D OriginalColorTexture; 
uniform sampler2D ColorTexture; 
uniform float DeltaT;
uniform float ttime;
uniform float ResolutionMultiplier;
uniform float alltime;


const float InverseMaxInt = 1.0 / 4294967295.0;


float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed,1.0)-0.5;
	float y=randhash (uint(seed+uint(413)),1.0)-0.5;
	float z=randhash (uint(seed*uint(14)),1.0)-0.5;
	return vec3(x,y,z);

};



void main()
{

	vec4 glVertex= gl_Vertex;
	int rnd=gl_VertexID;
	int MyIndex=rnd;
	int poss=int(rnd);
	int x=poss%1536;
	int y=poss/1536;

	// get current position from positionTexture
	glVertex.xyz=texture (PositionTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;


	vec3 GPUColors=texture (ColorTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;
	float SizeW=texture (PositionTexture,0.9999*vec2 (float(x),float(y))/1536.0).w;
	vec3 OriginalColors=texture (OriginalColorTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;
	glVertex.w=1.0;
	gl_Position =  glVertex;
	position=gl_Position.xyzw;

	position.x+=10;

	position.x/=20.0;

	float fstop=clamp ((ttime-30)*0.12,0.0,1.0);

	position.x+=ttime*0.09-clamp ((ttime-30)*0.09*fstop,0.0,10000.0);
	position.x=mod (position.x,1.0);
	position.x*=20.0;
	position.x-=10.0;


	gl_Position = gl_ModelViewProjectionMatrix *position;
	thecolor=vec4 (0.2,0.3,0.2,1.0);
	gl_PointSize=2.0;

	thecolor.xyz=OriginalColors.xyz*0.6*vec3 (0.2,0.4,0.5);

	thecolor.xyz=GPUColors;




	if (ttime<35)
	{ 


		if (poss%113==0){
			gl_PointSize=clamp (SizeW*0.5,0.0,1.0)*randhash (uint(MyIndex),1.0)*50.0*(0.5+0.5*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));;
			thecolor+=(2.0*vec4 (1.8,0.7,0.3,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));

		}


		if (poss%64==0){
			gl_PointSize=4.0+clamp (SizeW*0.5,0.0,1.0)*randhash (uint(MyIndex),1.0)*10.0*(0.5+0.5*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));;
			thecolor+=(2.0*vec4 (2.7,0.9,0.4,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));
		}
	}

	if (ttime>35) { 

		if (poss%1113==0){
			gl_PointSize=clamp (SizeW*0.5,0.0,1.0)*randhash (uint(MyIndex),1.0)*100.0*(0.5+0.1*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));;
			thecolor+=(3.0*vec4 (0.5,1.0,1.3,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.9+0.1*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));

		}


		if (poss%164==0){
			gl_PointSize=4.0+clamp (SizeW*0.5,0.0,1.0)*randhash (uint(MyIndex),1.0)*20.0*(0.5+0.1*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));;
			thecolor+=(3.0*vec4 (0.2,0.4,0.6,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (uint(MyIndex*3),1.0)));
		}
	}





	if (poss%23313==0){
		gl_PointSize*=5.0*randhash (uint(MyIndex*42),1.0);
	}

	thecolor*=vec4 (1.0-pow(gl_Position.z*0.08,1.0));
	//if (ttime>59.5) 	thecolor*=14-13*clamp ((ttime-59.5)*0.3,0.0,1.0);
	
	gl_PointSize*=1+0.3*(1.0-pow(gl_Position.z*0.06,2.0));
	
	gl_PointSize*=1-0.3*clamp ((ttime-61)*0.5,0.0,1.0);
		gl_PointSize *=ResolutionMultiplier;

		
		
		float fdsp3=0.67+sin (0.12+0.25*0.5*2*3.1415926*alltime*100.0/60.0);
fdsp3=clamp (fdsp3,0.0,1.0);
fdsp3=pow (fdsp3,2.0);



//if (ttime>3) 
if (ttime<34.0)
{ 

			if (randhash (uint(MyIndex*22),1.0)<0.03) 
thecolor*=1+3.0*fdsp3;



		if (randhash (uint(MyIndex*71),1.0)<0.003) 
		{
			float fcc=fdsp3*pow (randhash (uint(MyIndex*23),1.0),23.0);
	gl_PointSize*=1+16*fcc;
	gl_PointSize=clamp (gl_PointSize,0.0,30.0);
	thecolor*=clamp (1-3*fcc,0.0,100.0);

}

		
		if (randhash (uint(MyIndex*32),1.0)<0.013) 
		{
			float fcc=fdsp3*pow (randhash (uint(MyIndex*23),1.0),23.0);
	gl_PointSize*=1+6*fcc;
	gl_PointSize=clamp (gl_PointSize,0.0,30.0);
	thecolor*=clamp (1+3*fcc,0.0,100.0);

}


}

		
		
		
		//gl_PointSize*=0.7;
		gl_PointSize=clamp (gl_PointSize,1.0,3000.0);












		thecolor*=1.1+2.0*clamp ((ttime-56)*0.3,0.0,1.0);
	//texture (PositionTexture,vec2 (float(x),float(y))/1024.0).w;
}