#version 430
uniform float ttime;
uniform float alltime;
uniform float DeltaT;
uniform float PosY;

//uniform image2D destTexPos;
//uniform image2D destTexCol;
float   hash(float v);
vec2    rhash(vec2 uv);

layout (binding=0) writeonly uniform image2D destTexPos;
layout (binding=1) writeonly uniform image2D destTexVel;
layout (binding=2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture; 
uniform sampler2D ColorTexture; 
uniform sampler3D CurlTexture; 

uniform sampler2D OriginalPositionTexture; 
uniform sampler2D OriginalColorTexture; 

uniform sampler2D OriginalPositionTexture_Text; 
uniform sampler2D OriginalColorTexture_Text; 

uniform sampler2D OriginalPositionTexture_Bird;


uniform sampler1D Original1DTexture;
layout (local_size_x = 16, local_size_y = 16) in;

layout (std140, binding=4) buffer Pos { vec4 Positions[]; }; 
layout (std140, binding=5) buffer Vel { vec4 Velocities[]; }; 
layout (std140, binding=6) buffer Col { vec4 Colors[]; }; 


const float InverseMaxInt = 1.0 / 4294967295.0;

float hash(float v)
{
	return fract(fract(v/1e4)*v-1e6);
}

vec2 rhash(vec2 uv) {
	const mat2 t = mat2(.12121212,.13131313,-.13131313,.12121212);
	const vec2 s = vec2(1e4, 1e6);
	uv *= t;
	uv *= s;
	return  fract(fract(uv/s)*uv);
}



float voronoi(const in vec2 uv)
{
	vec2 p = floor(uv);
	vec2 f = fract(uv);
	float v = 0.;
	for( int j=-1; j<=1; j++ )
		for( int i=-1; i<=1; i++ )
		{
			vec2 b = vec2(i, j);
			vec2 r = b - f + rhash(p + b);
			v += 1./pow(dot(r,r),8.);
		}
		return pow(1./v, 0.0625);
}




vec3 Rotate (vec3 Input, mat4 RotationM) { 
	vec4 Inn=Input.xyzz;
	Inn.w=1.0;
	Inn=RotationM*Inn;

	float fc=1.0-clamp (pow (length (Input)*1.1,1.0)+0.0,0.3,1.0);
	fc=0.4+0.4*sin(1*length (Input)+ttime);
	fc*=clamp ((ttime-100)*0.5,0.0,1.0);
	fc=0;
	Inn.xyz+=(Input-Inn.xyz)*fc;

	return Inn.xyz;

};





float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed,1.0)-0.5;
	float y=randhash (seed+413,1.0)-0.5;
	float z=randhash (seed*2+12,1.0)-0.5;
	return vec3(x,y,z);

};

vec3 GetCurl (vec3 Pos) { 

	return texture (CurlTexture,Pos.xyz).xyz;
};



float Octave (vec2 UV) { 
	float ff=0.5;
	float fv=int (UV.x*ff*20)/(ff*20.0);
	float fvy=int (UV.y*ff*40)/(ff*40.0);
	fv=0;
	fvy=0;
	float fy=voronoi (13*vec2(-fv+UV.x+ttime*0.073,fvy+UV.y+ttime*0.03+ttime*0.0));
	fy*=voronoi (11*vec2(UV.x-ttime*0.053,fvy+UV.y-ttime*0.02+ttime*0.0));
	// fy+=sin(voronoi (6*vec2(UV.x+ttime*0.073,UV.y-ttime*0.02+ttime*0.0)));
	fy+=(voronoi (10.4*vec2(UV.x-ttime*0.043,fv+UV.y-ttime*0.023+ttime*0.0)));

	fy*=1*voronoi (4*vec2(UV.x-ttime*0.043,fvy+UV.y+ttime*0.0+ttime*0.0));
	fy+=1.4*voronoi (33.4*vec2(fv+UV.x-ttime*0.042,UV.y+fvy-ttime*0.01+ttime*0.0))		*voronoi (6.4*vec2(fv+UV.x-ttime*0.033,UV.y+fvy-ttime*0.03+ttime*0.0))
		;

	fy+=0.3*sin(ttime+15.0*length (vec2 (1.0,0.2)*(UV-vec2 (0.5))));
	//fy=0.5+0.5*sin(fy*2);

	// fy*=0.5;
	//fy=voronoi (vec2(UV.x,UV.y)*8.0)*0.0;
	return fy;



};



float Octave2(vec2 UV) { 
	float ff=0.5;
	float fv=int (UV.x*ff*20)/(ff*20.0);
	float fvy=int (UV.y*ff*40)/(ff*40.0);
	fv=0;
	fvy=0;
	UV.y*=0.6;
	float fy=voronoi (13*vec2(-fv+UV.x+ttime*1.043,fvy+UV.y+ttime*0.03+ttime*0.0));
	fy*=voronoi (11*vec2(UV.x+ttime*0.043,fvy+UV.y-ttime*0.02+ttime*0.0));
	fy+=voronoi (6*vec2(UV.x+ttime*0.143,UV.y-ttime*0.02+ttime*0.0));
	fy+=voronoi (10.4*vec2(UV.x+ttime*0.043,fv+UV.y-ttime*0.02+ttime*0.0));
	fy+=1.4*voronoi (6.4*vec2(fv+UV.x+ttime*0.053,UV.y+fvy-ttime*0.01+ttime*0.0))
		*voronoi (6.4*vec2(fv+UV.x+ttime*0.033,UV.y+fvy-ttime*0.03+ttime*0.0))
		;

	fy*=voronoi (4*vec2(UV.x-ttime*0.223,fvy+UV.y-ttime*0.01+ttime*0.0));
	fy+=0.3*sin(ttime+15.0*length (vec2 (1.0,0.0)*(UV-vec2 (0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};



#define INVOCATION_SIZE (1536)
void main() {

	float TotalParticles=1.0/float(1536*1536);

	uint MyIndex=gl_GlobalInvocationID.x+gl_GlobalInvocationID.y*INVOCATION_SIZE;
	float fMyIndex=float(MyIndex);
	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
	float fMyIndexX=float(gl_GlobalInvocationID.x)*1.0/1536.0;
	float fMyIndexY=float(gl_GlobalInvocationID.y)*1.0/1536.0;

	vec2 fMyIndexXY=vec2 (fMyIndexX,fMyIndexY);

	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime*0.01)+0.01*Positions[MyIndex].xyz)*10.0*DeltaT;
	float phii=1.2;
	vec3 OriginalPos=4.0*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	vec3 BirdPos=vec3 (0.0,1.5,0.0)+1.2*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).zyx;
	vec3 OtherObject=1.1*texture (OriginalPositionTexture_Bird,vec2(storePos.x,storePos.y)*(1.0/1536.0)).zyx;
	OtherObject.z*=0.9;
	vec3 RotO;
	RotO.y=cos(ttime*0.3+phii)*OtherObject.y+sin (ttime*0.3+phii)*OtherObject.z;
	RotO.z=-sin(ttime*0.3+phii)*OtherObject.y+cos (ttime*0.3+phii)*OtherObject.z;
	
	OtherObject.yz=RotO.yz;

	OtherObject.y*=-1;
	OtherObject.y+=-4;
	OtherObject.x+=3.04;
	BirdPos.y+=clamp (pow((ttime-50),1.0),0.0,1000.0)*0.7;
	OtherObject.y+=clamp (pow((ttime-50),1.0),0.0,1000.0)*0.7;



	vec3 MyPos=OriginalPos;
	float fy=Octave (fMyIndexXY);
	float fry=	(Octave2 (23.0*fMyIndexXY));

	// fy*=voronoi (12*vec2(fMyIndexX+ttime*0.043,fMyIndexY-ttime*0.03+ttime*0.0));
	OriginalPos=vec3 (fMyIndexX*20-10,fy*0.4,fMyIndexY*20-10);
	bool ismiddle=false;


	if (MyIndex%230==0) {
		OriginalPos=vec3 (fMyIndexX*20-10,fy*0.1,fMyIndexY*20-10);

		OriginalPos.y+=randhash (MyIndex*41,1.0)*20.0;

	}




	float fccc=clamp ( (ttime-5)*1.0,0.0,1.0);
	fccc=1.0;

	if (fMyIndexY>0.5-0.05*fccc)
		if (fMyIndexY<0.5+0.05*fccc)
			ismiddle=true;


	/*

	if (ismiddle)
	{

	if (ttime<25)	
	OriginalPos.y=1.0;
	else
	OriginalPos.y=0.0;

	OriginalPos.y=110.0;
	}
	*/




	vec3 VInside=vec3 (0,5,0);

	float dis=abs(mod (-ttime*0.09+0.4,1.0)-fMyIndexX)*5.0;
	dis=1.0-clamp (dis,0.0,1.0);

	//iginalPos+=(VInside-OriginalPos)*dis;




	vec3 Disturb=GetCurl (vec3 (ttime*0.00)+0.06*Positions[MyIndex].xyz)*1.0+vec3 (0.0,0.0,0.0);
	Disturb+=GetCurl (vec3 (ttime*0.000)+0.11*Positions[MyIndex].xyz)*1.0;


	if (ttime>10000) { 

		if (OriginalPos.z<0.5)
			Disturb+=vec3 (0.0,0.0,4.0)*dis;
		else
			Disturb-=vec3 (0.0,0.0,4.0)*dis;
	}

	//Disturb+=vec3 (0.0,0.0,6.0)*dis;
	float oct=1.0;
	if (ttime>23+2*randhash (MyIndex*71,1.0))
		if (ttime<32+randhash (MyIndex*3,1.0))
			oct=8.0;

	float vor2=voronoi (oct*5.5*vec2(fMyIndexX+ttime*0.0,fMyIndexY-ttime*0.0+ttime*0.0));
	//r2=0.5+0.5*sin(5*vor2+ttime);


	//	if (vor2>0.5) vor2=1; else vor2=-100.0;
	
	//if (ttime<55)
	Disturb+=vec3 (0,1+0.8*pow(randhash (MyIndex,1.0),35.0),0);



	float fc=clamp ((PosY-fMyIndex*0.000001)*0.6,0.0,1.0);



	float vor3=2.9+randhash (MyIndex*4,1.0)*0.0+1.5*voronoi (4*vec2(fMyIndexX+ttime*0.02,fMyIndexY-ttime*0.04+ttime*0.0));



	float PosYY=0.98;
	if (ttime<2.0)
		PosYY=10.0;



	//if (!ismiddle)	
	{
		PosYY-=clamp ((ttime-7.0)*0.2,0.0,1.0)*0.25;
		PosYY+=clamp ((ttime-22.0)*0.2,0.0,1.0)*0.1;

	}
	//if (ttime>25) PosYY=0.7+0.0*sin(ttime*2.0);

	PosYY+=1.3*clamp ((ttime-31.0-fMyIndex*0.000001)*0.5,0.0,1.0);




	



	/*

	if ((MyIndex%10000<-8000)) { 
		PosYY-=1.6*clamp (ttime-35.0,0.0,1.0);




		if (ttime>380) { 
			Disturb=GetCurl (vec3 (ttime*0.00)+0.06*Positions[MyIndex].xyz)*1.0+vec3 (0.0,0.0,0.0);
			Disturb+=GetCurl (vec3 (ttime*0.000)+0.13*Positions[MyIndex].xyz)*0.0;
			//sturb.x+=1.5;
			vec3 BirdPosDist=(BirdPos-vec3 (0,1.5,0));
			BirdPosDist.y=abs (BirdPosDist.y);
			if (ttime>46)
			if (MyIndex%743<85) {

				BirdPosDist.y*=-13;
			
			}
			

			Disturb+=BirdPosDist;




			if (MyIndex%1000<30) 
				Disturb*=0.0;


		};



	}

	*/
	







	fc=clamp ((PosYY-vor2)*0.6,0.0,1.0);
//		fc+=clamp (-(ttime-58)*10.0,-10.0,10.0);

	if (ttime>310)
		if (MyIndex%10000<8000)
		{ 
			PosYY=0.5+PosY;

			Disturb=GetCurl (vec3 (ttime*0.00)+0.06*Positions[MyIndex].xyz)*1.0+vec3 (0.0,0.0,0.0);
			Disturb+=GetCurl (vec3 (ttime*0.000)+0.11*Positions[MyIndex].xyz)*1.0;
			Disturb.x-=BirdPos.x*1.0;
			fc=clamp (PosYY-sin(ttime*0.3+fMyIndex*0.001)*1,0.0,1.0);;
		}



	if (ttime>36+fMyIndex*0.000001) { 

		if (MyIndex%424<70)
		if ((MyIndex%10000<8000) || (ismiddle) ) 
		{ 
			fc=0.5-2.2*sin(ttime*0.09+fMyIndex*0.003);
			
			float fz=pow(clamp (sin(ttime*1.5+fMyIndex*0.0000002),0.0,1.0),10.0);
			fc+=1.5*fz;

			//3.3*clamp (ttime-42.0-4.0*(0.5+0.5*sin(fMyIndexY*8))*1,0.0,1.0);
			//PosYY=-100;
		
			Disturb=GetCurl (vec3 (ttime*0.00)+0.06*Positions[MyIndex].xyz)*1.0+vec3 (0.0,0.0,0.0);
			Disturb+=GetCurl (vec3 (ttime*0.000)+0.13*Positions[MyIndex].xyz)*0.3;
			//sturb.x+=1.5;
			vec3 BirdPosDist=(BirdPos-vec3 (0,1.5,0));
			//BirdPosDist.y=abs (BirdPosDist.y);
			if (ttime<55)
			Disturb+=BirdPosDist;
			
			Disturb.x*=0;
			Disturb*=0.5;

		}

		if ((MyIndex%10000<8000) || (ismiddle) ) 
		{ 
			//fc+=-1.0*sin(ttime*0.0+fMyIndex*0.003);

		}



	}


	if (ttime>58) 
		Disturb*=0.9;

	if (ttime>36+4.0*sin(fMyIndexY*3.14159))
		if (!((MyIndex%10000<8000) || (ismiddle) ) )
		{ 
			//fc+=-1.0*sin(ttime*0.0+fMyIndex*0.003);
			fc=0.0;
			Disturb=GetCurl (vec3 (ttime*0.00)+0.055*Positions[MyIndex].xyz)*1.0+vec3 (0.0,0.0,0.0);
			Disturb+=GetCurl (vec3 (ttime*0.000)+0.11*Positions[MyIndex].xyz)*0.7;
			Disturb+=vec3 (0,1.2+pow(randhash (MyIndex*42,1.0),24.0)*1.5,0)*2.0;
			//3.3*clamp ((ttime-36.0-fMyIndex*0.000001)*0.5,0.0,1.0);

		}



		//fc-=vor3*0.2;
		//fc+=clamp ((ttime-55)*0.5,0.0,11.0);
		if (ttime>55) 
			Disturb.x+=0.0+0.0*randhash (MyIndex*3,1.0);

		/*
		if (ttime>55) { 
			Disturb*=0.1;
			fc=1.0+0.5*sin (ttime*0.5+fMyIndex*0.001);

		};

		*/
		fc=clamp (fc,0.0,1.0);
	


		//fc-=0.9;

		//if (fc<0.05) 			fc=0.0;

		Positions[MyIndex].w=1-fc;






		Positions[MyIndex].w=clamp (	Positions[MyIndex].w,0.0,1.0);


		if ((MyIndex%10000<8000) || (ismiddle) ){ 
			//OriginalPos+=(BirdPos-OriginalPos)*clamp ((ttime-30-fry*0.1-BirdPos.y*0.1+fMyIndex*0.00000)*1.0,0.0,1.0);
			float finter=clamp ((ttime-30-0.2*fMyIndexX)*0.5,0.0,1.0);
			//finter-=clamp ((ttime-36-fMyIndexY)*0.5,0.0,1.0);
			OriginalPos+=(BirdPos-OriginalPos)*finter;
		}





		float snaptime=59.5;



			float clt=clamp ((ttime-53-fMyIndex*0.000001),0.0,1.0);
	 clt=clamp (1000.0*(ttime-snaptime-sin(fMyIndex*0.00)),0.0,1.0);
	// clt-=clamp (0.5*(ttime-70-sin(fMyIndex*0.00)),0.0,1.0);
	//clt=0;8

	 if (ttime>70) { 


	//	 OriginalPos=randhash3 (MyIndex)*100.0;

	 };



	 
if (ttime>snaptime) {
	fc+=0.4;	 

fc*=clamp (abs(3.0*sin (ttime*0.03+fMyIndex*0.00001)),0.0,1.0);
//if (MyIndex%1000<50)
//fc-=clamp ((ttime-65-fMyIndex*0.000001)*0.3,0.0,100.0);
fc=clamp (fc,0.0,1.0);
Disturb+=vec3 (1,0,0);
}


OriginalPos+=(OtherObject-OriginalPos)*clt;;

/*
if (MyIndex%100<90)
if (ttime>74-fMyIndex*0.000001) { 
	Disturb.x*=0.3;
	Disturb+=vec3 (-0.0,-7.0,0.0);
	fc=0.0;
}

*/




		float alldist=length ((OriginalPos-Positions[MyIndex].xyz));
		fry=abs (fry);

		fry=pow(fry,4.0)*0.4;
		//OriginalPos=MyPos;

		Positions[MyIndex].w=alldist*1.0;


		if (MyIndex%1131!=0)
		{

			float fm=1;
			fm-=clamp ((ttime-12)*0.2,0.0,1.0);
			fm+=clamp ((ttime-23-fMyIndexX*2.0)*0.2,0.0,1.0);
			if (MyIndex%130==0)
				fm=1;
			fy*=fm;
			// (fc<0.1) fy*=0.5;
			//fyf=clamp (fy,0.0,0.2);
			//fy*=0.3;
		}

		Colors[MyIndex].xyz=vec3 (0.2,0.3,0.5)*(fy)*0.8+vec3 (1.0,1.0,1.5)*fry*0.2;;
		Colors[MyIndex].xyz=(vec3 (0.2,0.3,0.4)*(fy)*1.0+vec3 (1.0,1.0,1.0)*fry*fy*0.3)*2.4;


		float moon;
		//=length (vec2 (fMyIndexX,fMyIndexY)-vec2 (0.5));
		float moon2=1.0-length (-vec2 (vor2)*0.02+(vec2 (mod (fMyIndexX-0.1+ttime*0.09,1.0),fMyIndexY)-vec2 (0.5))*vec2 (0.7,3.0));
		moon2=clamp (moon2,0.0,1.0);
		moon=1.5*pow(moon2,10.0);
		//moon=0;

		if (ttime>62) { 
			float fcc=1-clamp ((ttime-67)*0.5,0.0,1.0);
			Disturb+=vec3 (0.0,clamp ((ttime-62-fMyIndex*0.000002)*0.6,0.0,1.0),0.0)*-10.0*fcc;
		//	Disturb*=1-clamp (ttime-72,0.0,1.0);
		};


		//Colors[MyIndex].xyz=vec3 (0.2,0.3,0.3)*(fy)*0.8+vec3 (1.0,1.0,1.5)*fry*0.0;;

		if (ismiddle)
		{
			//		Colors[MyIndex].xyz=Colors[MyIndex].xyz*vec3 (0.6,0.4,0.4)+vec3 (0.0);
		}

		Colors[MyIndex].xyz+=(fry+0.7)*moon*vec3 (1.0,0.8,0.4)*(1.0-clamp ((ttime-18)*0.3,0.0,1.0));
		Colors[MyIndex].xyz*=1+2.0*alldist;



//if (ttime<10.0)


		/*
		if (randhash (MyIndex*71,1.0)<0.007) 
		{ 
float fdsp3=2*sin (+0.4+0.25*0.5*2*3.1415926*alltime*100.0/60.0+fMyIndex*0.0000001);
fdsp3=clamp (fdsp3,0.0,1.0);
fdsp3=pow (fdsp3,1.0);
fc-=fdsp3*0.2*randhash (MyIndex*23,1.0);
//OriginalPos.y+=fdsp3*3.0*randhash (MyIndex*23,1.0)*randhash (MyIndex*23,1.0);;;;
//Disturb*=1+fdsp3*5.0*randhash (MyIndex*23,1.0);
		}
		*/




		Positions[MyIndex].xyz+=Disturb*DeltaT;
		Positions[MyIndex].xyz+=(OriginalPos-Positions[MyIndex].xyz)*fc;



		imageStore(destTexPos, storePos, Positions[MyIndex]);
		imageStore(destTexVel, storePos, Velocities[MyIndex]);
		imageStore(destTexCol, storePos, Colors[MyIndex]);
}
