#version 330 core
out vec4 outpColor;
in vec2 UV;
uniform sampler2D inputtex;
uniform vec2 iResolution;
uniform float iGlobalTime;

const int kNsamples = 100;

float inside(vec2 uv, int type) {
    vec2 uvd = mod(uv * 10.0, 1.0) - vec2(0.5);
    return float(type == 1) * float(length(uvd) < 0.3) + 
           float(type == 2) * float(max(abs(uvd.x), abs(uvd.y)) < 0.3) +
           float(type == 3) * float(uvd.x + uvd.y > 0.3);
}

mat2 rot(float a) {
	return mat2( cos(a), -sin(a), sin(a),  cos(a) );
}

void main() {
	vec2 uv = UV;
    uv.x *= iResolution.x / iResolution.y;
    float outp = 0.0;
    
    // "motion blur"
    for (int i = 0; i < kNsamples; i++) {
        float ts = 2.0*iGlobalTime - float((i - 50)) / 1024.0;
        int type = 1;
        float is = inside(1.0 * abs(1.0 + 1.0 * sin(1.0*iGlobalTime)) * rot(0.2 * ts) * (uv - vec2(0.5)), type);
        outp += is;
    }
	outpColor = vec4(vec3(outp / float(kNsamples)),1.0) * texture2D(inputtex, UV);
}
