#version 330 core
layout(location=0) in vec3 vertex;
layout(location=1) in vec3 normal;
layout(location=2) in vec2 uv;
layout(location=3) in vec3 tangent;
layout(location=4) in vec3 bitangent;
out vec3 n;
out vec3 pos;
out vec3 dvec;
out vec3 cam;
out vec2 UV;
uniform mat4 MVP;
uniform mat4 MV;
uniform vec3 campos;

void main() {
	float disp = 1.0;
	vec4 nt = inverse(transpose(MV)) * vec4(normalize(normal), 1.0);
	vec3 inpvertex = vertex *disp;
    vec4 outputcoord = MVP * vec4(inpvertex, 1.0);
    vec4 worldcoord = MV * vec4(inpvertex, 1.0);

	n = normalize(nt.xyz);
    pos = worldcoord.xyz;
    dvec = inpvertex;
    UV = uv;
	gl_Position = outputcoord;
}
