#version 330 core
in vec3 n;
in vec3 pos;
in vec3 dvec;
in vec3 cam;
in vec2 UV;

uniform sampler2D ambienttex;
uniform float ambientmixer;

layout(location = 0) out vec4 color;

vec4 edgecol() {
  float col = 1.0 - max(0.0, dot(-n, normalize(pos - cam)));
  col = smoothstep(0.75, 1.0, col);
  return vec4(vec3(col), 1.0);
}

vec4 ambientcol() {
  return texture(ambienttex, UV);
}

void main() {
	color = mix(edgecol(), ambientcol(), ambientmixer);
}
