#version 330 core
layout(location = 0) in vec3 vertex;
layout(location = 1) in vec3 uv;

out vec3 UV;
out float shadowcoef;
uniform sampler2D shadowconstants;
uniform sampler2D postex;
uniform sampler2D prevPostex;
uniform mat4 projMtx;
uniform mat4 viewMtx;

uniform sampler2D shadowmap;
uniform int shadowconstant;
uniform float shadowmapDimension;
uniform mat4 depthMVP;

float occlusion(vec3 pos, vec2 jitter) {
	vec4 candidate = depthMVP * vec4(pos, 1.0);
	return 1.0 - float(texture(shadowmap, jitter + candidate.xy * .5 + 0.5).r < candidate.z * .5 + .5);
}

float shadowterm(vec3 pos) {
	const int kernelr = 4;
	const int kernelw = 2 * kernelr + 1;
	float occ = 0.0;
	for (int i = -1 * kernelr; i <= kernelr; i++) {
		for (int j = -1 * kernelr; j <= kernelr; j++) {
			vec2 jitter = vec2(float(i), float(j)) / shadowmapDimension;
			occ += occlusion(pos, 2.0 * jitter);
		}
	}
	return occ / (kernelw * kernelw);
}

void main() {
	vec3 camR = vec3(viewMtx[0][0], viewMtx[1][0], viewMtx[2][0]);
	vec3 camU = vec3(viewMtx[0][1], viewMtx[1][1], viewMtx[2][1]);
	//vec3 camR = vec3(1.0, 0.0, 0.0);
	//vec3 camU = vec3(0.0, 1.0, 0.0);
	vec2 BillboardSize = vec2(1.0) / 64.0;
	vec3 pos = texture(postex, uv.xy).xyz;
	vec3 prev = texture(prevPostex, uv.xy).xyz;
	vec3 dlta = vec3(1.0); // normalize(pos - prev);
	// pos = (vertex.x + 0.5) * pos + (0.5 - vertex.x) * prev;
	vec3 vpw = pos
	           + camR * dlta.x * vertex.x * BillboardSize.x
	           + camU * dlta.y * vertex.y * cross(dlta, vec3(0.0, 1.0, 0.0)) * BillboardSize.y;
	//vec3 scale = vertex + vec3(0.5,0.5,0.0);
	//vpw = 
	gl_Position = projMtx * viewMtx * vec4(vpw, 1.0);
	UV = vertex + vec3(0.5, 0.5, 0.0);
	shadowcoef = texture(shadowconstants, uv.xy).r;
	return;

	if (shadowconstant == 1) {
		shadowcoef = shadowterm(vpw);
	} else {
		shadowcoef = 1.0;
	}
}
