#version 330 core
out vec4 outpColor;
in vec2 UV;
in vec3 pos;
in vec3 worldpos;
in float ccoef;
uniform sampler2D particleTex;
//uniform vec4 colormask;

// noise
float noise(vec2 pos)
{
	return fract( sin( dot(pos*0.001 ,vec2(24.12357, 36.789) ) ) * 12345.123);	
}

float noise(int a, int b, int c)
{
	return noise(vec2(float(a + sin(float(c))), float(b + c)));
}

vec4 dnoise3f( vec3 inp )
{
	float x = inp.x;
	float y = inp.y;
	float z = inp.z;

    int   i, j, k;
    float u, v, w;

    i = int(floor(x)); u = fract(x);
    j = int(floor(y)); v = fract(y);
    k = int(floor(z)); w = fract(z);

    float du = 30.0f*u*u*(u*(u-2.0f)+1.0f);
    float dv = 30.0f*v*v*(v*(v-2.0f)+1.0f);
    float dw = 30.0f*w*w*(w*(w-2.0f)+1.0f);

    u = u*u*u*(u*(u*6.0f-15.0f)+10.0f);
    v = v*v*v*(v*(v*6.0f-15.0f)+10.0f);
    w = w*w*w*(w*(w*6.0f-15.0f)+10.0f);

    float a = noise( i+0, j+0, k+0 );
    float b = noise( i+1, j+0, k+0 );
    float c = noise( i+0, j+1, k+0 );
    float d = noise( i+1, j+1, k+0 );
    float e = noise( i+0, j+0, k+1 );
    float f = noise( i+1, j+0, k+1 );
    float g = noise( i+0, j+1, k+1 );
    float h = noise( i+1, j+1, k+1 );

    float k0 =   a;
    float k1 =   b - a;
    float k2 =   c - a;
    float k3 =   e - a;
    float k4 =   a - b - c + d;
    float k5 =   a - c - e + g;
    float k6 =   a - b - e + f;
    float k7 = - a + b + c - d + e - f - g + h;

    return vec4(k0 + k1*u + k2*v + k3*w + k4*u*v + k5*v*w + k6*w*u + k7*u*v*w,
    	        du * (k1 + k4*v + k6*w + k7*v*w),
    	        dv * (k2 + k5*w + k4*u + k7*w*u),
    	        dw * (k3 + k6*u + k5*v + k7*u*v));
}

void main() {
	//outpColor = vec4(0.85, 0.96, 0.9, 0.3) * texture(particleTex, UV) * colormask;
	vec3 normal = dnoise3f(pos).gba;
    vec3 derivs = normal;
    vec3 velo = vec3(
  	derivs.y - derivs.z,
  	derivs.z - derivs.x,
  	derivs.x - derivs.y
  	); // hashtag hope
    float lifecoef = max(0.0, 4.0 * ccoef * (1.0 - ccoef));
    float distcoef = 1.0 / max(0.1, 0.5*length(vec3(-2.0) - worldpos));
    outpColor = texture(particleTex, UV) * (1.0 - max(0.5, dot(normalize(velo), normalize(vec3(-1.0, -1.0, -1.0))))) * lifecoef * distcoef;
    //outpColor = vec4(1.0,0.0,1.0,1.0);
}
