#version 330 core
layout(location=0) in vec3 vertex;
layout(location=1) in vec3 normal;
layout(location=2) in vec2 uv;
layout(location=3) in vec3 tangent;
layout(location=4) in vec3 bitangent;
out vec2 UV;
out vec3 n;
out vec3 t;
out vec3 bt;
out mat3 TBN;
out vec4 wVertex;
out vec4 worldPos;
uniform mat4 MVP;
uniform mat4 MV;


const float multipluyier = 0.0;
void main() {
	UV = uv;
	vec4 nt = inverse(transpose(MV)) * vec4(normal, 1.0);
	n = nt.xyz;
	vec4 vertexNormal_cameraspace = MV * vec4(normalize(normal), 0.0);
	vec4 vertexTangent_cameraspace = MV * vec4(normalize(tangent), 0.0);
	vec4 vertexBitangent_cameraspace = MV * vec4(normalize(bitangent), 0.0);
	t = tangent;
	bt = bitangent;
	TBN = transpose(mat3(
        vertexTangent_cameraspace.xyz,
        vertexBitangent_cameraspace.xyz,
        vertexNormal_cameraspace.xyz
    ));
    worldPos = vec4(vertex, 1.0);
	wVertex = MV * vec4(vertex, 1.0);
	gl_Position = MVP * vec4(vertex, 1.0);
}
