#version 330 core
uniform sampler2D normalmap;
uniform sampler2D envmap;
uniform sampler2D ambienttex;
const float envfactor = 1.0; // Shark: 1.0
const float ambientfactor = 0.0; // Shark: 0.0
in vec2 UV;
in vec3 n;
in vec3 t;
in vec3 bt;
in mat3 TBN;
layout(location = 0) out vec4 color;

vec3 toSpherical(vec3 n) {
	float X = n.x;
	float Y = n.y;
	float Z = n.z;
	float radius = length(n);
	return vec3(0.5 * (1.0 + 2.0 * atan(Y, X) / 3.141), acos(Z / radius)/3.141, radius);
}

void main() {
	vec3 localnormalT = normalize(texture(normalmap, UV).xyz * 2.0 - 1.0);
	vec3 polar = toSpherical(n);
	color = vec4(vec3(max(dot(normalize(localnormalT), normalize(inverse(transpose(TBN)) * vec3(1.0, 1.0, 1.0))), 0.0)), 1.0);

	vec4 envcolor = envfactor * vec4(vec3(max(dot(normalize(localnormalT), normalize(TBN * vec3(1.0, 1.0, 1.0))), 0.2)), 1.0) * texture(envmap, polar.xy);
	// envcolor = texture(envmap, polar.xy); // Uncomment for shark
	vec4 acolor = ambientfactor * texture(ambienttex, UV).rrrr / 2.0;
	color = envcolor + acolor;
//	color = vec4(1.0,0.0,1.0,1.0);
	//color= texture(normalmap, UV);
	//color = texture(normalmap, UV);
	//color *= texture(normalmap, vec2(UV.x, 1.0) - vec2(0.0, UV.y));
	//color = vec4(bt, 1.0);
}
