#version 330 core
uniform float skale;
in vec4 wVertex;
in vec4 worldPos;
layout(location = 0) out vec4 color;

void main() {
	color = vec4(vec3(float(mod(wVertex.y * skale, 1.0) < 0.5)), 1.0);
	//return;
	// from engine
	const float siilinjarviCoefficient = 1.0;
	float quantity = worldPos.y * 10.0 / length(worldPos); // worldpos pitäisi olla jokin eri?
	float realval = quantity * siilinjarviCoefficient;
	float prev = floor(realval);
	float next = ceil(realval);
	float mindist = min(abs(realval - prev), abs(realval - next));
	float modulofactor = smoothstep(mindist*mindist, 0.0, 0.02) * float(mod(prev, 2.0) < 0.1);
	modulofactor = mod(prev, 2.0);
	//modulofactor = float(abs(mod(prev, 2.0)));


	color = vec4(vec3(0.1), 0.0) + vec4(modulofactor * vec3(1.0) * smoothstep(abs(worldPos.y), 0.0, 0.2) * 0.9, 1.0);
}
/*
void sphere() {
	const float siilinjarviCoefficient = 1.0;
	float quantity = worldPos.y * 10.0 / length(worldPos); // worldpos pitäisi olla jokin eri?
	float realval = quantity * siilinjarviCoefficient;
	float prev = floor(realval);
	float next = ceil(realval);
	float mindist = min(abs(realval - prev), abs(realval - next));
	float modulofactor = smoothstep(mindist*mindist, 0.0, 0.02) * float(mod(prev, 2.0) < 0.1);
	modulofactor = float(abs(mod(prev, 2.0)));


	color = vec4(vec3(0.1), 0.0) + vec4(modulofactor * vec3(1.0) * smoothstep(abs(worldPos.y), 0.0, 3.0) * 0.9, 1.0);
	outnormal = vec4(-n, 1.0);*/
