#version 330 core

// Interpolated values from the vertex shaders
#define iChannel0 inputtex
in vec2 UV;
uniform sampler2D inputtex;
uniform float iGlobalTime;
uniform vec2 iResolution;

// output
layout(location = 0) out vec4 fragcolor;


/////////////////////////////////
const float HOELDER_MAKINEN_MAGIC_CONSTANT = 2.0; //0.707;

mat2 rotate(float a) {
    return mat2(cos(a), sin(a), -sin(a), cos(a));
}

float intensity(vec4 color) {
    return dot(vec3(.2126, .7152, .0722), sqrt(color.rgb));
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 sampleme(vec2 uv) {
    
    vec2 unrotd = uv;
    float ar = (iResolution.y/iResolution.x);
    uv = rotate(42.5 * 3.141 / 180.0) * vec2(uv.x, uv.y*ar);

    float nballs = 200.0;
    vec2 center = 2.0*fract(nballs * uv ) - 1.0;
    float dist = length(center);

    float radius = intensity(texture2D(iChannel0, unrotd));
    vec4 highlight = vec4(0.0, 0.0, 0.0, 1.0);
    vec4 background = vec4(1.0, 1.0, 1.0, 1.0);
    return mix(background, highlight, step(radius, dist));
}

vec4 htone()
{
  vec2 uv = UV;
  vec4 fragcolor = sampleme(uv);
  for (int i = 0; i < 4; i++) {
      vec2 pt = uv + 0.5*rotate(20.0 + float(i) * HOELDER_MAKINEN_MAGIC_CONSTANT*3.141 / 4.0) * vec2(0.5, 0.0) / iResolution.xy;
      fragcolor += sampleme(pt);
  }
  fragcolor = fragcolor / 5.0;
  return fragcolor * texture(iChannel0, UV);
}
