#version 330 core
in vec3 n;
in vec3 pos;
in vec3 dvec;
layout(location = 0) out vec4 color;

vec3 intersect(vec3 p, vec3 normal) {
	float a = length(normal) * length(normal);
	float b = 2.0 * dot(p, normal);
	float c = length(p) * length(p) - 10.0;
	float s = (-b + sqrt(b * b - 4 * a * c)) / (2.0 * a);
	return p + s * normal;
}

vec4 colorize(vec3 p) {
	float cv = 10.0*p.y;
	float stripea = smoothstep(0.95, 1.05, mod(cv, 2.0));
	float stripeb = 1.0 - smoothstep(1.90, 2.00, mod(cv, 2.0));
	float stripe = stripea * stripeb;
	return vec4(vec3(stripe), 1.0);
}

void main() {
	color = colorize(intersect(dvec, n));
	color = colorize(n) * max(0.0, dot(n, -normalize(vec3(0.0) - pos)));
	color.xyz = vec3(1.0);
	color.a = 0.1;
}
