import QtQuick 2.3
import QtQuick.Dialogs 1.1
import QtQuick.Layouts 1.1
import QtQuick.Controls 1.2

import AdaptDemoSystem 1.0

Item {
    id: root
    visible: true
    width: 1600*0.35
    height: 900*0.35

    opacity: 0.0

    // set this to true for instant start of demo without the dialog
    property bool bInstantStart: false

    // settings
    property bool bFullScreen: false
    property bool bEditViewEnabled: false
    property bool bRocketEnabled: false

    // default resolution
    property string defaultResolution: "1280x720"
//    property string defaultResolution: "640x480"

    Component.onCompleted: {
        opacity = 1.0;
    }

    Behavior on opacity {
        NumberAnimation { duration: 1000 }
    }


    Rocket {
        id: rocket
        Component.onCompleted: {
            rocket.setFullScreen(bFullScreen);
            rocket.setEditViewEnabled(bEditViewEnabled);
            rocket.setRocketEnabled(bRocketEnabled);

            if (!bEditViewEnabled) {
                checkBoxEditView.enabled = false;
                checkBoxEditView.visible = false;
            }

            if (!bRocketEnabled) {
                checkBoxRocketEnabled.enabled = false;
                checkBoxRocketEnabled.visible = false;
            }

            if (bInstantStart) {
                startDemoTimer.start()
            }
        }
    }

    Timer {
        id: startDemoTimer
        repeat: false
        interval: 10
        onTriggered: {
            rocket.startDemo()
        }
    }


    Rectangle {
        anchors.fill: parent
        gradient: Gradient {
            GradientStop {
                position: 0.00;
                color: "#ffffff";
            }
            GradientStop {
                position: 0.19;
                color: "#94bed3";
            }
            GradientStop {
                position: 0.63;
                color: "#e4e4e4";
            }
            GradientStop {
                position: 1.00;
                color: "#ffffff";
            }
        }
    }

  Image {
        fillMode: Image.PreserveAspectCrop
        anchors.centerIn: parent
        anchors.verticalCenterOffset: 60.0+20.0*Math.sin(animTime*0.2)
        //source: "../images/startDialog.png"
        source: "../images/PinkMedusa.png"

    }

    Text {
        text: "Copyright (C) adapt 2015"
        anchors.right: root.right
        anchors.bottom: root.bottom
        anchors.margins: 10
    }

    RowLayout {
        anchors.fill: parent
        anchors.leftMargin: 50
        anchors.rightMargin: 50
        Button {
            text: "START DEMO"; isDefault: true
            onClicked: {
                rocket.startDemo()
            }
        }
        Item { Layout.fillWidth: true }
        Button {
            text: "QUIT"
            onClicked: {
                rocket.exitDemo()
            }
        }
    }

    Rectangle {
        anchors.fill: settings
        anchors.margins: -50
        opacity: 0.8
        color: "white"
    }

    GroupBox {
        id: settings
        title: ""
        flat: true
        Layout.fillWidth: true
        anchors.centerIn: parent
        ColumnLayout {
            anchors.centerIn: parent
            anchors.verticalCenterOffset: -20
            CheckBox {
                text: "Fullscreen"; checked: bFullScreen
                onClicked: {
                    rocket.setFullScreen(checked)
                }
            }
            CheckBox {
                id: checkBoxEditView
                text: "Edit view"; checked: bEditViewEnabled
                onClicked: {
                    rocket.setEditViewEnabled(checked)
                }
            }
            CheckBox {
                id: checkBoxRocketEnabled
                text: "Rocket enabled"; checked: bRocketEnabled
                onClicked: {
                    rocket.setRocketEnabled(checked)
                }
            }
        }
    }

    ListModel {
        id: res
        ListElement { text: "" }
    }

    ListModel {
        id: emptyResItem
        ListElement { text: "" }
    }

    ComboBox {
        anchors.centerIn: parent
        anchors.verticalCenterOffset: 40
        width: 150

        Component.onCompleted: {
            res.clear();
            for (var i=0; i<resolutions.length; i++) {
           //     console.log("resolution: "+resolutions[i].name)
                res.append(emptyResItem.get(0))
                res.get(i).text = resolutions[i].name;
            }
            currentIndex = find(defaultResolution);
        }
        model: res



        Layout.fillWidth: true
        onActivated: {
        //    console.log("selected resolution: "+textAt(index))
            rocket.setSelectedResolution(textAt(index))
        }
    }

}
