import QtQuick 2.3
import QtQuick.Window 2.2

import SystemTime 1.0

import AdaptDemoSystem 1.0

DemoRoot {
    id: root
    visible: true
    width: windowWidth
    height: windowHeight
    focus: true

    property bool bExitDemo: true
    property real exitDemoTime: 360.0

//    onActiveFocusChanged: {
//        if (activeFocus) {
//            console.log("Demo window got the focus");
//            root.setEditViewAsForegroundWindow();
//        }
//    }

    Rocket {
        id: rocket
    }

    property real time: 0.0

    Component.onCompleted: {
        time = 10000.0
    }
    Behavior on time {
        NumberAnimation { duration: 10000*1000 }
    }



    //    Item {
    //        id: loaderImage
    //        anchors.fill: parent
    //        Rectangle {
    //            anchors.fill: parent
    //            color: "orange"
    //        }
    //        Image {
    //            fillMode: Image.PreserveAspectFit
    //            anchors.fill:parent
    //            source: "../images/loader.png"
    //        }
    ////        Rectangle {
    ////            anchors.centerIn: parent
    ////            opacity: 1.0
    ////            radius: 5
    ////            width: 50
    ////            height: 10
    ////            color: "white"
    ////            rotation: time*20.0
    ////        }

    //    }

    //            Rectangle {
    //                opacity: 0.0
    //                radius: 5
    //                width: 10
    //                height: 10
    //                color: "black"
    //                rotation: time
    //            }

    Item {
        id: loaderImage
        anchors.fill: parent

        Image {
            anchors.fill: parent
            source: "../images/adapt_logo2_full.png"
        }

        Text {
            //text: "Loading, hold your horseshoes...."
            text: "Loading, please wait a momentos...."
            font.pixelSize: 20
            anchors.centerIn: parent
            anchors.verticalCenterOffset: 200
            color: "grey"
        }

    }
    //    property int huppa: 0

    //    Timer {
    //        interval: 20
    //        repeat: true
    //        running: true
    //        onTriggered: {
    //            huppa+=1;
    //        }
    //    }

    //    Image {
    //        anchors.centerIn: parent
    //        rotation: huppa*10
    //        source: "../images/stars2_blue.png"
    //    }


    Timer {
        interval: 200
        repeat: false
        running: true
        onTriggered: {
            //demoLoader.sourceComponent = demo
            demoLoader.source = "Skenes.qml"
            //  reloadDemo();
        }
    }

    Timer {
        id: delayedSetDemoLoaderSource
        interval: 200
        running: false
        repeat: false
        onTriggered: {
            demoLoader.source = "Skenes.qml";
            //reloadDemo();
        }
    }

    Connections {
        target: demoLoader.item
        onFileMissing: {
            console.log("QML received file not found:"+fName+" skene:"+sName);
        }
    }



    Timer {
        interval: 200
        repeat: true
        running: true
        onTriggered: {
            if (rocket.getTime() > exitDemoTime && bExitDemo) {
                rocket.exitDemo();
            }
        }
    }

    Loader {
        id: demoLoader
        anchors.fill: parent
        asynchronous: true
        onStatusChanged: {
            if (demoLoader.status === Loader.Ready) {
                console.log("xxxxxxxxxxxxxxx DEMO LOADER is ready xxxxxxxxxxxxxxxx")
                loaderImage.visible = false
                rocket.markDemoLoaded();

            }
        }
    }

//    Connections {
//        target: demo
//        onAckFirstDemoRender: {
//            console.log("AKU ANKKA");
//        }
//    }

    Keys.onEscapePressed: {
        console.log("esc esc")
        rocket.exitDemo();
    }


    Keys.onPressed: {
         console.log("event.key:"+event.key)
        if (event.key === 16777268) { // F5
            //console.log("jorma");
            // demoLoader.sourceComponent = undefined;
            demoLoader.source = "";
            rocket.reload();
            delayedSetDemoLoaderSource.start();

            //   demoLoader.sourceComponent = demo
        }
        if (event.key === 82) { // R
            rocket.reloadParticles();
        }

        if (event.key === 32) { // space
            if (rocket.getIsPaused()) {
                rocket.setPause(false);
            } else {
                rocket.setPause(true);
            }
        }

        if (event.key === 83) { // S
            // demoLoader.sourceComponent = demo
            // demoLoader.source = "Skenes.qml"
        }
        //        if (event.key === 84) { // T
        //             // demoLoader.sourceComponent = demo
        //            // demoLoader.source = "Skenes.qml"
        //            demoLoader.item.bDebugTexts = false;
        //            console.log("pressed")
        //        }
    }

}
