import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    property string name: "godray"
    effectName: "GodRay"
    enabled: sync(name+".ON")


    property real godRayX: 0.0
    property real godRayY: 0.0

    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }
    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }
    Shader {
        file: (sync(name+".realSpectrum") > 0.5) ? "godrayReal" : "godray"
        ShaderParam {
            paramName: "g_realSpecSpacing"
            paramValue: sync(name+".realSpecSpacing")+1.0
        }
        ShaderParam {
            paramName: "rayX"
            paramValue: sync(name+".x")+godRayX
        }
        ShaderParam {
            paramName: "rayY"
            paramValue: sync(name+".y")+godRayY
        }
        ShaderParam {
            paramName: "lightZ"
            paramValue: sync(name+".lightZ")+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync(name+".intensity")
        }
        ShaderParam {
            paramName: "g_origAmount"
            paramValue: sync(name+".origAmount")
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync(name+".specRounds")
        }
        ShaderParam {
            paramName: "g_specOfs"
            paramValue: sync(name+".specOfs")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync(name+".specWeight")
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync(name+".length")
        }
        ShaderParam {
            paramName: "g_loops"
            paramValue: sync(name+".loops")+64.0*1.5
        }
        ShaderParam {
            paramName: "g_rotateAmp"
            paramValue: sync(name+".rotateAmp")
        }
        ShaderParam {
            paramName: "g_rotatePrim"
            paramValue: sync(name+".rotatePrim")
        }
        ShaderParam {
            paramName: "g_rotateSinAmp"
            paramValue: sync(name+".rotateSinAmp")
        }
        ShaderParam {
            paramName: "g_rotateSinFreq"
            paramValue: sync(name+".rotateSinFreq")
        }
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false

    }
}

