import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    id: skene

    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }

//    MeshJupiter {
//        name: "jupiter"
//    }
    MeshJupiter {
        name: "jupiter2"
        //file: "mesh/cube5000.x"
        file: "mesh/Drill002.dae"
        scale: 1.0
    }

    Repeater {
        model: 8
        delegate: MeshJupiter {
            name: "kulmaKivi1"
            file: "mesh/ball5000.x"
            property string gsName: "jupiter2_"+(index+1)
            posX: getSavePointX(gsName)*0.20
            posY: getSavePointY(gsName)*0.20
            posZ: getSavePointZ(gsName)*0.20
            scale: 1.0
        }
    }

/*

    MeshJupiter {
        name: "kulmaKivi1"
        file: "mesh/ball5000.x"
        property string gsName: "jupiter2_1"
        posX: getSavePointX(gsName)
        posY: getSavePointY(gsName)
        posZ: getSavePointZ(gsName)
        scale: 1.0
    }
    MeshJupiter {
        name: "kulmaKivi2"
        file: "mesh/ball5000.x"
        property string gsName: "jupiter2_2"
        posX: getSavePointX(gsName)
        posY: getSavePointY(gsName)
        posZ: getSavePointZ(gsName)
        scale: 1.0
    }
    MeshJupiter {
        name: "kulmaKivi3"
        file: "mesh/ball5000.x"
        property string gsName: "jupiter2_3"
        posX: getSavePointX(gsName)
        posY: getSavePointY(gsName)
        posZ: getSavePointZ(gsName)
        scale: 1.0
    }
*/



//    MeshAdapt {
//        name: "jupiter2"
//        file: "mesh/cube5000.x"
//    }

    MeshPlane {
        name: "plane"
    }



    Vignette {
        posX: getSavePointX2D("jupiter2")
        posY: getSavePointY2D("jupiter2")
    }

    Vignette {
        name: "vignetteBasic"
        posX: getSavePointX2D("valopallo")
        posY: getSavePointY2D("valopallo")
    }


    GodRay {
        godRayX: getSavePointX2D("jupiter2")
        godRayY: getSavePointY2D("jupiter2")
    }
    Tonemap {
    }


}
