import QtQuick 2.3
import "../../" // to import RocketScene
import "../../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    property string name: "mesh"
    effectName: "Mesh"

    SetMaterial {
        shader: sceneDir+"smBg"
        texture0: sceneDir+"_SK57414.png"
        texture1: sceneDir+"_SK57414_normal.png"
        texture2: "images/area_lights1280.jpg"
    }

    DrawMesh {
        //Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        // property string name: "bg"
        //file: "mesh/Drill002.dae"
        file: "mesh/Cave.dae"
        depthTest: true
        depthWrite: true
        cull: true
        Pos { x: sync(name+".x"); y: sync(name+".y"); z: sync(name+".z"); }
        Rot { d: sync(name+".rot")+rocket.time; ax: 0.50; ay: 1.0; az: 0.0 }
        Sca { s: sync(name+".scale"); y: 1.0; }
        SavePoint {
            target: "valopallo"
            x: 0.0; y: 0.0; z: 0.0;
        }
        ShaderParam {
            paramName: "g_meshExplo"
            paramValue: sync(name+".explo")
        }
    }


}
