import QtQuick 2.3
import "../../" // to import RocketScene
import "../../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: mesh
    property string name: "mesh"
    effectName: "Mesh"
    property real scale: 1.0
    property real posX: 0.0
    property real posY: 0.0
    property real posZ: 0.0

    property string file: "mesh/ball5000.x"

    SetMaterial {
        shader: sceneDir+"smBg"
        //texture0: sceneDir+"_SK57414.png"
        texture0: "images/adapt_logo2_full.png"
        texture1: sceneDir+"_SK57414_normal.png"
        texture2: "images/area_lights1280.jpg"
    }

    DrawMesh {
        id: dm
        //Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        // property string name: "bg"
        //file: "mesh/Drill002.dae"
        file: mesh.file
        depthTest: true
        depthWrite: true

        property real meshScale: sync(name+".scale")

        Pos { x: posX+sync(name+".x"); y: posY+sync(name+".y"); z: posZ+sync(name+".z"); }
        Rot { d: sync(name+".rot")+rocket.time; ax: 0.50; ay: 1.0; az: 0.0 }
        Sca { s: dm.meshScale+mesh.scale; y: 1.0; }
        SavePoint {
            target: name
            x: 0.0; y: 0.0; z: 0.0;
        }
        SavePoint { target: name+"_1"; x: -1.0; y: -1.0; z: 1.0; }
        SavePoint { target: name+"_2"; x: 1.0; y: -1.0; z: 1.0; }
        SavePoint { target: name+"_3"; x: 1.0; y: 1.0; z: 1.0; }
        SavePoint { target: name+"_4"; x: -1.0; y: 1.0; z: 1.0; }
        SavePoint { target: name+"_5"; x: -1.0; y: -1.0; z: -1.0; }
        SavePoint { target: name+"_6"; x: 1.0; y: -1.0; z: -1.0; }
        SavePoint { target: name+"_7"; x: 1.0; y: 1.0; z: -1.0; }
        SavePoint { target: name+"_8"; x: -1.0; y: 1.0; z: -1.0; }

        ShaderParam {
            paramName: "g_meshExplo"
            paramValue: sync(name+".explo")
        }
    }


}
