import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {


    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }

    SetMaterial {
        shader: sceneDir+"smBg"
        texture0: "images/_SK57414.png"
        texture1: "images/_SK57414_normal.png"
    }


//    DrawMesh {
////        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }

//        property string name: "bg"
//        file: "mesh/aivob.x"
//        depthTest: true
//        depthWrite: true
//        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
//        Sca { s: 10.0; y: 3.0; x: 3.0; z: 0.30 }
//        ShaderParam {
//            paramName: "g_uvOfsX"
//            paramValue: sync("uvOfsX")+rocket.time*0.0
//        }
//    }



    Texture {
        textureUnit: 0
        textureItem: particleTexture
//        width: 1280
//        height: 720
        Image {
            id: particleTexture
           source: "../../images/adapt_logo2_full.png"
        }
    }

    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
           // source: "Levikset.png"
            source: "../../images/adapt_logo2_full.png"
           // source: "../../images/Stardust1.jpg"
            //source: "bokeh5.png"
        }
    }
    Texture {
        textureUnit: 3
        textureItem: particleEnv
        Image {
            id: particleEnv
            visible: false
            //source: "area_lights.jpg"
            source: "Bright-roof-multi.jpg"
            //source: "PeaceGardens_01_LDR.jpg"
            //source: "bokeh5.png"
        }
    }


    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
//            source: "random16.png"
       //     source: "../../images/bokeh_1.png"
            source: "../../images/particles_64_2048.png"
        }
    }

    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "vec3 posG; vec2 uvG; vec3 velG; float ageG; float recG; vec3 posInitG;"

    Shader {
        file: sceneDir+"ssPartTrans"
        tfVaryings: shaderVaryings
    }

    property int gridDimension: 600
    property real partSize: 0.250

    DrawVB {
        id: partSim
        enabled: true
        type: "pointGrid"
        property string name: "partSim15"
        vboId: sceneName+name

        property real resetOn: sync(name+".reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }


        tfVaryings: shaderVaryings

        gridWidth: gridDimension
        gridHeight: gridDimension
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_gridDim"
            paramValue: gridDimension
        }
//        ShaderParam {
//            paramName: "g_force"
//            paramValue: sync(partSim.name+".force")
//        }
//        ShaderParam {
//            paramName: "g_noiseFreq"
//            paramValue: sync(partSim.name+".noiseFreq")
//        }
//        ShaderParam {
//            paramName: "g_speed"
//            paramValue: sync(partSim.name+".speed")
//        }

//        ShaderParam {
//            paramName: "g_initShapeX"
//            paramValue: sync(partSim.name+".initShapeX")
//        }
//        ShaderParam {
//            paramName: "g_initShapeY"
//            paramValue: sync(partSim.name+".initShapeY")
//        }
//        ShaderParam {
//            paramName: "g_maxAge"
//            paramValue: sync(partSim.name+".maxAge")
//        }

//        ShaderParam {
//            paramName: "g_initPosX"
//            paramValue: sync(partSim.name+".initPosX")
//        }
//        ShaderParam {
//            paramName: "g_initPosY"
//            paramValue: sync(partSim.name+".initPosY")
//        }
//        ShaderParam {
//            paramName: "g_initPosZ"
//            paramValue: sync(partSim.name+".initPosZ")
//        }

    }

//    DrawVB {
//        enabled: true
//        type: "pointGrid"
//        vboId: sceneName+"partSim18"
//        property string name: vboId
//        reset: sync(name+"reset")
//        gridWidth: 1000
//        gridHeight: 1000
//        depthTest: false
//        depthWrite: false
//        ShaderParam {
//            paramName: "g_pikselos"
//            paramValue: sync("pikselos")
//        }
//    }




    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+"ssPart"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        property string name: "partSim15"
        vboId: sceneName+name
        depthTest: true
        depthWrite: false

        blendMode: "add"

        tfVaryings: shaderVaryings
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }

    }

//        DrawVB {
//            enabled: true
//            type: "pointGridDraw"
//            vboId: sceneName+"partSim18"
//    //        gridWidth: partW
//    //        gridHeight: partH
//            depthTest: true
//            depthWrite: false
//            ShaderParam {
//                paramName: "g_pikselos"
//                paramValue: sync("pikselos")
//            }
//            ShaderParam {
//                paramName: "g_partSize"
//                paramValue: 0.50
//            }
//        }


    Vignette {
    }
    GodRay {
        godRayX: getSavePointX2D("valopallo")
        godRayY: getSavePointY2D("valopallo")
    }
    Tonemap {
    }

}
