#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmitShape;
layout(binding=3) uniform sampler2D texEnv;

in vec3 posG;
in vec2 uvG;
in vec2 uvOrig;
in float sharpnessG;

in int gl_PrimitiveID;


layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

uniform float g_time;


#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}


vec3 rotateXY(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

void main() {

    //vec2 myUv = uvG*0.25;
    //myUv.y *= 4.0*9.0/16.0;

    vec2 myUv = uvG;

    myUv.y *= -1.0;

    float sharpness = sharpnessG; // 1.50+0.5*sin(g_time*10.0);

    /*
    vec2 myUv = uvG;
    //myUv.y *= 4.0*9.0/16.0;
*/

    vec4 result = texture2D(tex, myUv+vec2(0.0, 0.0));

    vec4 emitShape = texture2D(texEmitShape, uvOrig);
  //  result.r = 1.0;
    //result.rgb *= result.rgb;

    //result.r = 1.0;
    //result.a = 1.0;

    vec2 uvm = (uvG-vec2(0.5,0.5))*2.0;
    float dist = dot(uvm,uvm);

    vec2 uvNorm = uvm/sqrt(dist);

    float circle = clamp(1.0-dist*1.0, 0.0, 1.0);
    circle = clamp(smoothstep(0.0, 1.0, pow(circle*sharpness, 1.0))/clamp(sharpness, 0.0, 1.0), 0.0, 1.0);

    //circle *= emitShape.r;
    //result.rgb = vec3(circle)*1.0;
    int primID = gl_PrimitiveID;

    if ((primID&3)==0) {
        result.rgb = vec3(1.0);
    } else if ((primID&3)==1) {
        result.rgb = vec3(1.0, 1.0, 1.15);
    } else if ((primID&3)==2) {
        result.rgb = vec3(0.90, 0.90, 1.0);
    } else {
        result.rgb = vec3(0.5);
    }
/*
    vec3 normal = vec3(uvm.x, 0.0, uvm.y);
    float dist2 = dot(uvm.xy, uvm.xy);
    normal.y = sqrt(clamp(1.0-dist2, 0.0, 1.0));

    //vec4 posOfs = posG;
    normal.xy += 0.0*vec2(posG.x, -posG.y*9.0/16.0)/posG.z;
    normal = normalize(normal);
    //normal.xy *= 1.0;
    normal.y *= 1.0;
    normal.z += 1.0;
    //normal.xyz = normal.zxy;
    //normal.xzy = rotateXY(normal.xzy, 3.141592);
    //normal.xzy = rotateXY(normal.xzy, 3.141592*0.5);
*/

    vec3 normal = vec3(uvm.x, uvm.y, 0.0);
    float dist2 = dot(uvm.xy, uvm.xy);
    normal.z = sqrt(clamp(1.0-dist2, 0.0, 1.0));

    //vec4 posOfs = posG;
    normal.xy += 0.0*vec2(posG.x, -posG.y*9.0/16.0)/posG.z;
    normal.x = normal.x;
    normal = normalize(normal);
    vec3 eyeRay = vec3(posG.x, posG.y, posG.z*1.0);

    eyeRay = normalize(eyeRay/posG.z);
   // normal.xy *= -normal.xy;
     normal.xy *= 1.0;
    vec3 ref = reflect(eyeRay, normal);

    vec2 uvLatLong = latlong(ref);


    //result.rg = uvG.rg;
    result.rgb *= vec3(clamp(-normal.x-normal.y, 0.0, 1.0))*1.5;
    result.rgb += 1.0*pow(texture2D(texEnv, uvLatLong).rgb,vec3(1.0));// *1.0*clamp(normal.y, 0.0, 1.0);
    result.a = circle*1.0;

  //  result.rg = eyeRay.rg*0.01;

    result.rgb = pow(result.rgb, vec3(0.5));

    frag = result;

//    if (result.a < 0.25) {
//        discard;
//    }

    frag2 = vec4(clamp((1.0-result.a*result.a*0.0)*1.0+1.0, 0.0, 1.0), 0.0, 0.0, result.a);
}

