import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {


    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }


    SetMaterial {
        shader: sceneDir+"shader"
        texture0: "images/_SK57414.png"
        texture1: "images/_SK57414_normal.png"
    }

//    SetMaterial {
//        shader: sceneDir+"MeshDriller/smDriller"
//        //texture0: sceneDir+"_SK57414.png"
//        texture0: "images/_SK57414.png"
//        texture1: "images/_SK57414_normal.png"
//        texture2: "images/area_lights1280.jpg"
//    }


    DrawMesh {
//        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }

        property string name: "bg"
        file: "mesh/aivob.x"
       // file: "mesh/Drill002.dae"
        depthTest: true
        depthWrite: true
        Pos { x: 0.0; y: 0.0; z: 0.0 }
        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 20.0; y: 1.0; x: 1.0; z: 1.0 }

    }

    MeshDriller {
//        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        name: "driller"
    }


    PartSim {
        name: "partSim15"
    }


    Vignette {
    }
    GodRay {
        godRayX: getSavePointX2D("driller")
        godRayY: getSavePointY2D("driller")
    }
    Tonemap {
    }

}
