import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

Group {
    id: partSim
    property string name: "partSim"
    property int gridDimension: 10
    property real partSize: 10.0


    Blit {
        textureRT: "screenBuffer"
    }

    Texture {
        textureUnit: 0
        textureItem: particleTexture
        Image {
            id: particleTexture
            source: "../../images/images/particles_64_2048.png"
        }
    }

    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "../../images/random16.png"
        }
    }

    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
            source: "../../images/adapt_logo2_full.png"

        }
    }

    Texture {
        textureUnit: 3
        textureItem: particleEnv
        Image {
            id: particleEnv
            visible: false
            source: "../../images/Bright-roof-multi.jpg"
        }
    }


    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "vec3 posG; vec2 uvG; vec3 velG; float ageG; float recG; vec3 posInitG;"

    Shader {
        file: sceneDir+"ssPartTrans"
        tfVaryings: shaderVaryings
    }



    DrawVB {
        enabled: true
        type: "pointGrid"
        vboId: sceneName+name

        property real resetOn: sync(partSim.name+".reset")

        onResetOnChanged: {
            if (resetOn > 0.5) {
                reset = 1.0;
                resetParticles();
            } else {
                reset = 0.0;
            }
        }

        tfVaryings: shaderVaryings

        gridWidth: gridDimension
        gridHeight: gridDimension
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_gridDim"
            paramValue: gridDimension
        }

        ShaderParam {
            paramName: "g_noiseScale"
            paramValueVec4: sync(partSim.name+".noiseScale.x")+","+sync(partSim.name+".noiseScale.y")+","+sync(partSim.name+".noiseScale.z")
        }

        ShaderParam {
            paramName: "g_force"
            paramValue: sync(partSim.name+".force")
        }
        ShaderParam {
            paramName: "g_noiseFreq"
            paramValue: sync(partSim.name+".noiseFreq")
        }
        ShaderParam {
            paramName: "g_speed"
            paramValue: sync(partSim.name+".speed")
        }

        ShaderParam {
            paramName: "g_initShapeX"
            paramValue: sync(partSim.name+".initShapeX")
        }
        ShaderParam {
            paramName: "g_initShapeY"
            paramValue: sync(partSim.name+".initShapeY")
        }
        ShaderParam {
            paramName: "g_maxAge"
            paramValue: sync(partSim.name+".maxAge")
        }

        ShaderParam {
            paramName: "g_initPosX"
            paramValue: sync(partSim.name+".initPosX")
        }
        ShaderParam {
            paramName: "g_initPosY"
            paramValue: sync(partSim.name+".initPosY")
        }
        ShaderParam {
            paramName: "g_initPosZ"
            paramValue: sync(partSim.name+".initPosZ")
        }

    }


    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+"ssPart"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        property string name: "partSim15"
        vboId: sceneName+name
        depthTest: true
        depthWrite: false

        blendMode: "add"

        tfVaryings: shaderVaryings
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: partSize
        }

    }
}
