import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene {

    id: skene

    ShakyCamera {
        camShakePosAmp: sync("camera.shake.amp")
        camShakeLookAtAmp: sync("camera.shakeLookAt.amp")
        camShakeFreq: sync("camera.shake.freq")
    }

    MeshSun {
        name: "sun"
    }

    MeshPlanet {
        rotateAround: "sun"
        name: "plan1"
        textureName: "images/planet_ice.png"
    }
    MeshPlanet {
        rotateAround: "sun"
        name: "plan2"
        textureName: "images/gas4.png"
    }
    MeshPlanet {
        rotateAround: "sun"
        name: "plan3"
        textureName: "images/gas5.png"
    }
    MeshPlanet {
        rotateAround: "sun"
        name: "plan3_1"
        textureName: "images/gas5.png"
    }
    MeshPlanet {
        rotateAround: "sun"
        name: "plan4"
        textureName: "images/prismainsideA-7.jpg"
    }
//    MeshBasic {
//        name: "basic"
//    }

//    MeshPlane {
//        name: "plane"
//    }


    MeshDriller {
//        Clear { cR: 0.0; cG: 0.0; cB: 0.0 }
        name: "driller"
    }


    PartSim {
        name: "partSim123"

        gridDimension: sync(name+".gridDim")
        partSize: sync(name+".partSize")

    }




    Vignette {
        posX: getSavePointX2D("sun")
        posY: getSavePointY2D("sun")
    }
    GodRay {
        godRayX: getSavePointX2D("sun")
        godRayY: getSavePointY2D("sun")
    }
    Tonemap {
    }


}
