import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    id: planet
    property string name: "mesh"
    effectName: "Mesh"
    property string shader: "smPlanet"

    property string textureName: "images/gas1.png"

    property string rotateAround

    SetMaterial {
        shader: sceneDir+"smPlanet"
        texture0: textureName
        texture1: textureName
        texture2: "images/area_lights1280.jpg"
    }

    DrawMesh {
        //Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        // property string name: "bg"
        //file: "mesh/Drill002.dae"
        file: "mesh/ball5000.x"
        depthTest: true
        depthWrite: true

        Pos { x: -getSavePointX(planet.rotateAround); y: -getSavePointY(planet.rotateAround); z: -getSavePointZ(planet.rotateAround); }
        Rot { d: sync(name+"rotAround"); ax: 0.0; ay: 1.0; az: 0.0; }
        Pos { x: getSavePointX(planet.rotateAround); y: getSavePointY(planet.rotateAround); z: getSavePointZ(planet.rotateAround); }

        Pos { x: sync(name+".x"); y: sync(name+".y"); z: sync(name+".z"); }
        Rot { d: sync(name+".rot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(name+".rot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync(name+".rot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(name+".scale"); }
        SavePoint {
            target: name
            x: 0.0; y: 0.0; z: 0.0;
        }
        ShaderParam {
            paramName: "g_meshExplo"
            paramValue: sync(name+".explo")
        }
    }


}
