  static int mSH[][8] = {
    { 1, 5, 5, 1,     3, 12, 12, 3 },
    { 3, 2, 3, 2,     2, 2, 2, 2 }
  };


float phiOfs, thetaOfs; 

#pragma code_seg(".code_seq_calcSH") 
static void calcSH(vec3 &p, float theta, float phi) {
   static float r;
   static float temp[4];
   static float sinphi;
   temp[0] = sinf(mSH[selectedSH][0]*phi+phiOfs);
   temp[1] = cosf(mSH[selectedSH][1]*phi+phiOfs);
   temp[2] = sinf(mSH[selectedSH][2]*theta+thetaOfs);
   temp[3] = cosf(mSH[selectedSH][3]*theta+thetaOfs);
   int ii=3;
   r=0.0f;
   do {
     r+=powisafe(temp[ii], mSH[selectedSH][ii+4], 1);
   } while (ii--);
   r = 1.0f+lerp(rFactor, 0.0f, r);
   sinphi = sinf(phi*0.999f+0.0005f*PI);
   p[0] = shScale[0]*r*sinphi*cosf(theta);
   p[1] = shScale[1]*r*cosf(phi);
   p[2] = shScale[2]*r*sinphi*sinf(theta);
}



   duSH = PI2/(float)resolutionSH; // Theta
   dvSH = PI/(float)resolutionSH;  // Phi  


   for (int i=0;i<=resolutionSH;i++) {
      u = i * duSH;
      if (i>0) {
        glBegin(GL_QUAD_STRIP);
      }
      for (int j=0;j<resolutionSH;j++) {
         v = j * dvSH;

         // quad-strip alternative 1b
         glEvalSH(u, v);
         if (i > 0) {
          glNormal3fv(nC[j]);
          glTexCoord2f(texCoordC[j][0], texCoordC[j][1]);
          ((PFNGLMULTITEXCOORD3FVARBPROC)c_glprocs[4])(GL_TEXTURE1_ARB, tangentC[j]);
          ((PFNGLMULTITEXCOORD3FVARBPROC)c_glprocs[4])(GL_TEXTURE2_ARB, bitangentC[j]);
          glVertex3fv(pC[j]);
         }
         vec3set(nC[j], n);
         vec3set(texCoordC[j], texCoord);
         vec3set(tangentC[j], tangent);
         vec3set(bitangentC[j], bitangent);
         vec3set(pC[j], p);

       //  glEvalSH(u+duSH, v);

      }
      if (i>0) {
        glEnd();
      }
   }
   