#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texG;

in vec4 posG;
in vec3 normalG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec3 controlG;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

// layout(location = 0) out uvec4 uex_colour;
// layout(location = 1) out vec4 ex_colour;

uniform float g_time;

uniform float g_alpha = 1.0;

void main() {

    vec3 normal = normalG;
    vec2 uv = uvG;
    vec3 tangent = tangentG;
    vec3 color = colorG;

    vec2 myUv = uv*1.0;

    vec4 diffuse = texture2D(tex, myUv.xy*1.0)*1.2+vec4(3.0);
    //  diffuse.rgb *= color;

    vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
    vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
    vec3 lightDir = lightPos-surfPos;

    float lightDist = sqrt(dot(lightDir, lightDir));

    vec3 myNormal = normal;
    vec3 biTangent = cross(myNormal, tangent);

    float bs = 1.0;
    float bumpX = bs*(texture2D(tex, myUv.xy+vec2(1.0/512.0, 0.0)).g-texture2D(tex, myUv.xy+vec2(-1.0/512.0, 0.0)).g);
    float bumpY = bs*(texture2D(tex, myUv.xy+vec2(0.0, 1.0/512.0)).g-texture2D(tex, myUv.xy+vec2(0.0, -1.0/512.0)).g);
    myNormal += tangent*bumpX + biTangent*bumpY;


    float normalLen = sqrt(dot(myNormal, myNormal));

    float d = dot(lightDir, myNormal)/(lightDist*normalLen);
    d = clamp(d, 0.0, 1.0);

    frag = diffuse*(d*0.25+0.01) + 1.0*pow(d, 512.0);

    vec4 c = frag;

    c.r = pow(c.r, 0.31);
    c.g = pow(c.g, 0.883);
    c.b = pow(c.b, 0.52);

    c.a = diffuse.a*0.3;

    float depthi = 1.0-(gl_FragCoord.z*gl_FragCoord.w-0.0)*2.0;

    c.a = 1.0;
    frag = vec4(c.r, c.g, c.b, c.a)*1.0;
    frag.rgb = pow(frag.rgb, vec3(3.0))*2.0;

    frag.a = 0.30;


    frag.a *= g_alpha;

    if (frag.a < 0.01) {
        discard;
    }

    // rt buffer 2: godray/glow, depth, partikles around screen
    frag2 = vec4(0.0, depthi, 0.0, g_alpha);
}

