#version 430

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texG;
layout(binding=2) uniform sampler2D texEnv;

in vec4 posG;
in vec3 normalG;
in vec2 uvG;
in vec3 tangentG;
in vec3 colorG;
in vec3 controlG;

layout(location = 0) out vec4 frag;
layout(location = 1) out vec4 frag2;

// layout(location = 0) out uvec4 uex_colour;
// layout(location = 1) out vec4 ex_colour;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}


uniform float g_time;

uniform float g_alpha = 1.0;


#define PI 3.1415926

vec2 latlong(vec3 v) {
  v = normalize(v);
  float theta = acos(v.z); // +z is up
  float phi = atan(v.y, v.x) + PI;
  return vec2(phi, theta)*vec2(.1591549, .6366198);
}

uniform mat4 modelViewMatrix;
uniform mat4 modelViewInvMatrix;

void main() {

    vec3 normal = normalG;
    vec2 uv = uvG;
    vec3 tangent = tangentG;
    vec3 color = colorG;

    vec2 myUv = uv*1.0;


    vec4 texCol = texture2D(tex, myUv.xy*1.0);
    texCol *= texCol;
    vec4 diffuse = texCol*1.2+vec4(3.0);
    //  diffuse.rgb *= color;

    vec3 lightPos = vec3(0.0*cos(g_time*2.0), 0.0, 5.0);
    vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
    vec3 lightDir = lightPos-surfPos;

    float lightDist = sqrt(dot(lightDir, lightDir));

    vec3 myNormal = normal;
    vec3 biTangent = cross(myNormal, tangent);

    float bs = 1.0;
    float bumpX = bs*(texture2D(tex, myUv.xy+vec2(1.0/512.0, 0.0)).g-texture2D(tex, myUv.xy+vec2(-1.0/512.0, 0.0)).g);
    float bumpY = bs*(texture2D(tex, myUv.xy+vec2(0.0, 1.0/512.0)).g-texture2D(tex, myUv.xy+vec2(0.0, -1.0/512.0)).g);
    myNormal += tangent*bumpX + biTangent*bumpY;


    float normalLen = sqrt(dot(myNormal, myNormal));

    float d = dot(lightDir, myNormal)/(lightDist*normalLen);
    d = clamp(d, 0.0, 1.0);

    frag = diffuse*(d*0.25+0.01) + 1.0*pow(d, 512.0);

    vec4 c = frag;

    c.r = pow(c.r, 0.31);
    c.g = pow(c.g, 0.883);
    c.b = pow(c.b, 0.52);

    c.a = diffuse.a*0.3;

    float depthi = 1.0-(gl_FragCoord.z*gl_FragCoord.w-0.0)*2.0;



    vec2 ssPos = gl_FragCoord.xy*vec2(1.0/1280.0, 1.0/720.0)*1.0;
    ssPos.y = ssPos.y;

    ssPos -= vec2(0.5, 0.5);
    ssPos *= 1.05;
    ssPos += vec2(0.5, 0.5);

    vec3 eyeRay = vec3(ssPos.xy, posG.z);

    eyeRay = normalize(eyeRay);
    vec3 ref = reflect(eyeRay, -normal);

    ref = (modelViewInvMatrix * vec4(ref, 0.0)).xyz;

    //ref = normalize(ref);
     ref.xzy = rotateXY3(ref.xzy, -3.141592*0.50);
     ref.yzx = rotateXY3(ref.yzx, -3.141592*0.5);
   // ref = rotateXY3(ref, 3.141592*0.5);

    vec2 uvLatLong = latlong(ref.xyz);
   // uvLatLong.y *= 0.50;
    c.rgb *= 1.0+vec3(clamp(normal.x, 0.0, 1.0))*1.0;
    vec3 envColor = texture2D(texEnv, uvLatLong).rgb;
    c.rgb += 0.0*envColor*envColor;
/*
    vec2 uvLatLongPrev = uvLatLong;
    uvLatLongPrev.x *= -1.0;
    //c.rgb += 1.0*pow(texture2D(texPrevFrame, uvLatLongPrev).rgb,vec3(1.0));
    vec2 norkor = posG.xy/posG.z;
    norkor.xy *= 0.8;
    //norkor.y *= 1.1;
    norkor.xy = norkor.xy*0.5+0.5;
    //norkor.x *= 9.0/16.0;
    c.rgb += 1.0*pow(texture2D(texPrevFrame, (norkor.xy)+0.50*normal.xy).rgb,vec3(1.0));
*/


    c.a = 1.0;
    frag = vec4(c.r, c.g, c.b, c.a)*1.0;
    frag.rgb = pow(frag.rgb, vec3(1.0))*0.70;

    frag.a = 0.30;

    frag.a *= g_alpha;

    if (frag.a < 0.01) {
        discard;
    }

    // rt buffer 2: godray/glow, depth, partikles around screen
    frag2 = vec4(0.0, depthi, 0.0, g_alpha);
}

