import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        x:0.0; y:0.0; z:-2.0
        lookAtX:0.0; lookAtY:0.0; lookAtZ:0.0
        upX:0.0; upY:1.0; upZ:0.0
        viewAngle:45.0
    }


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: -1.0
        upZ: 0.0
        viewAngle: sync("camera.viewAngle")
    }
/*
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/apo-mist-9090724-357_2.png"
        }
    }

    Shader {
        file: sceneDir+"ssPartTrans"
        tfVaryings: "posG,uvG"
    }
    DrawVB {
        enabled: true
        type: "pointGrid"
        gridWidth: 200 //windowWidth/4
        gridHeight: 200 // windowHeight/4
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }

    Shader {
        file: sceneDir+"ssPart"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        gridWidth: 200 //windowWidth/4
        gridHeight: 200 // windowHeight/4
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }

*/

    MeshDriller {
        name: "driller"
    }



    Texture {
        textureUnit: 0
        textureItem: kuvaxx
        Image {
            id: kuvaxx
            visible: false
            source: "../../images/gas1.png"
        }
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }
    Shader {
        file: sceneDir+"smJelly"
    }
    Repeater {
        model: 150
        DrawMesh {
            file: "mesh/medusasmooth.lwo"
            //file: "mesh/medusa.lwo"
            depthTest: true
            depthWrite: false
            blendMode: "add"
            property real jellyAreaScale: sync("jellyAreaScale")
            enabled: index<sync("jellyNum")
            property real jellySize: 0.0
            onEnabledChanged: {
                if (enabled) {
                    jellySize = 1.0
                } else {
                    jellySize = 0.0
                }
            }
            Behavior on jellySize {
                NumberAnimation { duration: 1000 }
            }

            Pos {
                x: Math.sin(index*1.2)*2.0*jellyAreaScale
                y: Math.cos(index*1.7123)*2.0*jellyAreaScale
                z: Math.cos(index*2.3+Math.sin(index*0.92))*1.0*jellyAreaScale
            }
            Rot { d: rocket.time*7.8+index*36.7*0.2139; ax: 1.0; ay: 0.50; az: 0.0 }
            Sca { s: sync("jellyScale")*jellySize; x: 1.0; y:1.5; z:1.0 }
            ShaderParam {
                paramName: "g_jellyAnimOfs"
                paramValue: sync("jellyAnimOfs")+index*1.7731
            }
        }
    }


    Blit {
        textureRT: "glassBg"
    }



    Texture {
        textureUnit: 1
        textureItem: kko
        Image {
            id: kko
            visible: false
            source: "../../images/random16.png"
        }
    }
    Texture {
        textureRT: "glassBg"
        textureUnit: 2
    }


    Shader {
        file: sceneDir+"sm"
    }

    Repeater {
        model: 10
        delegate: DrawMesh {
            id: meshu
            file: "mesh/PalmTree.dae"
            property real yr: Math.cos(index*13123.122)*10.0+12.0
            property real zr: Math.sin(Math.cos(index*23123.122)*1231231.2)*10.0+12.0
            property real xr: Math.sin(index*23123.122)*10.0+12.0
            Pos { x: meshu.xr; y: meshu.yr; z: meshu.zr; }
            Sca { s: 6.0+0.8*Math.sin(index*12.13) }

            ShaderParam {
                paramName: "g_makkara"
                paramValue: index == 0 ? sync("makkara") : 0.0
            }


            ShaderParam {
                paramName: "g_shatter"
                paramValue: sync("shatter")
            }

            ShaderParam {
                paramName: "g_wave"
                paramValue: rocket.time+index*2.93
            }
            SavePoint {
                target: "jorma"
            }
        }
    }

    DrawOverlayAdd {
        enabled: sync("greetings1") > 0.01
        file: "greetings1.png"
        overlayAlpha: sync("greetings1")
    }
    DrawOverlayAdd {
        enabled: sync("greetings2") > 0.01
        file: "greetings2.png"
        overlayAlpha: sync("greetings2")
    }
    DrawOverlayAdd {
        enabled: sync("greetings3") > 0.01
        file: "greetings3.png"
        overlayAlpha: sync("greetings3")
    }
    DrawOverlayAdd {
        enabled: sync("greetings4") > 0.01
        file: "greetings4.png"
        overlayAlpha: sync("greetings4")
    }
    DrawOverlayAdd {
        enabled: sync("greetings5") > 0.01
        file: "greetings5.png"
        overlayAlpha: sync("greetings5")
    }

    Vignette {
        posX: 0.0 //getSavePointX2D("sun")
        posY: 0.0 //getSavePointY2D("sun")
    }
    GodRay {
        godRayX: getSavePointX2D("jorma")
        godRayY: getSavePointY2D("jorma")
    }
    Tonemap {
    }



}
