import QtQuick 2.3
import "../../" // to import RocketScene
import "../../_SharedQML"
import AdaptDemoSystem 1.0


Group {
    property string name: "mesh"
    effectName: "Mesh"

    SetMaterial {
        shader: sceneDir+"MeshDriller/smDriller"
        //texture0: sceneDir+"_SK57414.png"
        texture0: "images/adapt_logo2_full.png"
        texture1: "images/_SK57414_normal.png"
        texture2: "images/area_lights1280.jpg"
    }

    DrawMesh {
        //Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        // property string name: "bg"
        file: "mesh/Drill002.dae"
        //file: "mesh/ball5000.x"
        depthTest: true
        depthWrite: true
        Pos { x: sync(name+".x"); y: sync(name+".y"); z: sync(name+".z"); }
        Rot { d: sync(name+".rot.z")+rocket.time; ax: 0.0; ay: 0.0; az: 1.0 }
        Rot { d: sync(name+".rot.x")+rocket.time; ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync(name+".rot.y")+rocket.time; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: sync(name+".scale"); y: 1.0; }
        SavePoint {
            target: name
            x: 0.0; y: 0.50; z: 0.0;
        }
        ShaderParam {
            paramName: "g_meshExplo"
            paramValue: sync(name+".explo")
        }
    }


}
