#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(points) in;
layout(points) out;
layout(max_vertices = 4) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 vs_pos[];
in vec2 uv[];

out vec3 posG;
out vec2 uvG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;

uniform float g_pikselos = 0.0;

void main(void) {


   // mat4 mvp = projectionMatrix * modelViewMatrix;

    vec3 pos = vs_pos[0];

  //  pos.x += 0.001*sin(pos.x*10.4+g_time)*0.1;
  //  pos.y += 0.001*cos(pos.y*12.2*sin(pos.x*3.4)+g_time)*0.1;

    vec4 noiseValue = texture2D(tex, uv[0]+vec2(0.0, 0.0));

    pos.xy += noiseValue.xy*0.1;


    //pos.x += 10.0*sin(g_time);
    //pos.y += 10.0*cos(g_time);

    posG = pos;
    uvG = uv[0];
    EmitVertex();
    EndPrimitive();

//    posG = pos;
//    uvG = uv[0];
//    EmitVertex();
//    EndPrimitive();

}
