#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;
//layout(line_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];

out vec4 posG;
out vec3 normalG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

uniform float furLength = 1.0;

uniform float g_fracturePoint = 0.0;
uniform float g_fractureStrength = 1.0;


// uniform float makkara;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;

//3d noise from iq
float noise(in vec3 x) {
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
    vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
    vec2 rg = texture2D( texNoise, (uv+ 0.5)/256.0, -100.0 ).yx;

    return mix( rg.x, rg.y, f.z );
}

float fbm(in vec3 x) {
    float rz = 0.;
    float a = .35;
    for (int i = 0; i<2; i++)
    {
        rz += noise(x)*a;
        a*=.35;
        x*= 4.;
    }
    return rz;
}


void main(void) {

        vec3 controlBase = vec3(0.0);



       float times = g_time*0.1;
       vec3 faceNormal = vec3(0.0);
        vec4 facePos = vec4(0.0);
        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position; // -vec4(1.5, 0.0, 0.0, 0.0);
                gl_Position.xyz -= normal[i]*0.0;
                facePos += origPos[i];
        //	gl_Position.xyz -= normal[i]*1.5;
                gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
                normalG = normal[i];
                colorG = vec3(1.90, 0.92, 0.9925)*5.0;
                normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
                posG = gl_Position;
             //   controlG = controlBase;
             //   controlG.r = 0.1;
                faceNormal += normal[i];
                uvG = uv[i];
                tangentG = tangent[i];
        //        EmitVertex();
        }
        facePos /= 3.0;

        for (int i = 0; i < gl_in.length(); ++i) {
            gl_Position = gl_in[i].gl_Position;
            vec2 uvMod = (uv[0]-vec2(0.50,0.50))*1.0;
            uvMod.y += -0.0;
            float distanceToMiddle = dot(uvMod,uvMod);
            distanceToMiddle = pow(distanceToMiddle*1.0, 0.50);
            float fracture = 1.0/(0.03+distanceToMiddle);
            fracture = clamp(fracture-40.0+g_fracturePoint,0.0, 1000000.0);

            fracture *= g_fractureStrength;

            vec3 radialVec = vec3(uvMod, 0.2);

            gl_Position.xyz -= normal[i]*0.0 + 0.0*faceNormal*sin(gl_Position.y*4.5+g_time)-0.05*fracture*vec3(0.0, 0.0, 1.0)-0.05*fracture*radialVec;

            gl_Position.xy += fracture*vec2(noise(gl_Position.xyz)-0.50, noise(gl_Position.xyz*2.1+vec3(0.0, 0.1, 1.0)*g_time)-0.5)*0.10;

            gl_Position.xyz -= -fracture*1.5*vec3(0.0, 0.0, 1.0)-0.5*fracture*radialVec;

            facePos += origPos[i];
            gl_Position.xyz -= normal[i]*0.0;
            gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
            normalG = normal[i];
            colorG = vec3(1.90, 0.92, 0.9925)*5.0;
            normalG = (modelViewMatrix * vec4(normalG, 0.0)).xyz;
            posG = gl_Position;
         //   controlG = controlBase;
         //   controlG.r = 0.1;
            uvG = uv[i];
            tangentG = tangent[i];
            EmitVertex();
        }
        facePos /= 3.0;

        EndPrimitive();



}
