#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 4) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 vs_pos[];
in vec2 uv[];

out vec3 posG;
out vec2 uvG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;

uniform float g_pikselos = 0.0;

uniform float g_gridDim = 100;
uniform float g_initShapeX = 100.0;
uniform float g_initShapeY = 100.0;
uniform float g_initShapeZ = 0.0;
uniform float g_initPosX = 0.0;
uniform float g_initPosY = 0.0;
uniform float g_initPosZ = 0.0;

void main(void) {


   // mat4 mvp = projectionMatrix * modelViewMatrix;

    vec3 pos = vs_pos[0];
    vec2 myUv = uv[0];


    float distFromOrig = dot(pos,pos);

    if (distFromOrig > 10.50 || (abs(pos.x)+abs(pos.y)+abs(pos.z))<0.001) {
        int prim = gl_PrimitiveID;

        int gridDim = int(g_gridDim);

        int primZ = 0;
        int primY = int(prim/gridDim);
        int primX = prim-primY*gridDim;

        float pullaU = float(primX)/float(gridDim);
        float pullaV = float(primY)/float(gridDim);

        pos.x = (pullaU-0.5)*g_initShapeX+g_initPosX;
        pos.z = (pullaV-0.5)*g_initShapeY+g_initPosZ;
        pos.y = 0.0;

        myUv.x = -pullaU*1.0+0.0;
        myUv.y = pullaV*1.0+0.0;

    }


    vec2 uvNois = uv[0];

    float tkk = 0.05;

    uvNois.x += cos(g_time*tkk+sin(g_time*tkk*1.2));
    uvNois.y += sin(g_time*tkk*1.23+cos(g_time*tkk*0.912));

    vec4 result = texture2D(texNoise, uvNois*0.10+vec2(0.0, 0.0));


//    pos.x += 0.001*sin(pos.x*10.4+g_time)*0.1;
//    pos.y += 0.001*cos(pos.y*12.2*sin(pos.x*3.4)+g_time)*0.1;
//    pos.z += 0.02*cos(pos.y*51.2*cos(pos.x*12.4)+g_time)*0.1;

    pos.z += abs(0.10*(result.r*1.0-0.5)*0.20);
    pos.x += 0.0*(result.g*1.0-0.5)*0.20;
    pos.y += 0.0*(result.b*1.0-0.5)*0.20;

    pos.z += 0.0003;

    float maxZ = 0.02;

    if (pos.z > maxZ) {
        pos.z = -maxZ;
    }

   // vec4 result = texture2D(tex, uv[0]+vec2(0.0, 0.0));


    //pos.x += 10.0*sin(g_time);
    //pos.y += 10.0*cos(g_time);

    posG = pos;
    uvG = myUv;
    EmitVertex();
    EndPrimitive();

//    posG = pos;
//    uvG = uv[0];
//    EmitVertex();
//    EndPrimitive();

}
