import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene {

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
    }

//    Shader {
//        file: "smDust"
//    }
//    TextureImage {
//        textureUnit: 0
//        file: "../../images/StarDusts1.png"
//    }
//    TextureImage {
//        textureUnit: 1
//        file: "../../images/_SK57414_normal.png"
//    }

    SetMaterial {
        shader: sceneDir+"smDust"
        texture0: "images/StarDusts1.png"
        texture1: "images/_SK57414_normal.png"
    }


//    Shader {
//        file: "smDust"
//    }
//    TextureImage {
//        textureUnit: 0
//        file: "../../images/StarDusts1.png"
//    }
//    TextureImage {
//        textureUnit: 1
//        file: "../../images/_SK57414_normal.png"
//    }

    //ZeppoHeviaMeetsBezier16.png
    DrawMesh {
//        Clear {
//            cR: 0.150; cG: 0.150; cB: 0.30
//        }
        property string name: "luola"
        file: "mesh/aivob.x"

        depthTest: true
        depthWrite: false

        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 1.50; y: 5.0; }

        ShaderParam {
            paramName: "g_uvOfsX"
            paramValue: sync("uvOfsX")+rocket.time*0.0
        }

    }



    Blit {
        textureRT: "previousFrameMeetDriller"
    }


    Shader {
        file: "smDriller"
    }
    Texture {
        textureUnit: 2
        textureItem: kuvasEnv
        Image {
            id: kuvasEnv
            visible: false
            source: "../../images/area_lights.jpg"
        }
    }
    Texture {
        textureUnit: 3
        textureRT: "previousFrameMeetDriller"
    }


    DrawMesh {
//        Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        property string name: "mesh2"
        file: "mesh/Drill002.dae"
       // file: "mesh/cone1.obj"

        Pos { x: sync("drill.x"); y: sync("drill.y"); z: sync("drill.z"); }
        Rot { d: sync("drillRot"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 0.50; x: 1.0; y: 1.0; z: 1.0 }

//        SavePoint {
//            target: "driller"
//            x: 0.0; y: 0.0; z: 0.0;
//        }
//        SavePoint {
//            target: "drillerMotor"
//            x: 0.0; y: 0.0; z: 0.0;
//        }

        SavePoint {
            target: "drillerNokka"
            x: 0.0; y: 2.0; z: 0.0;
        }
    }

    DrawMesh {
//        Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        property string name: "mesh2"
        file: "mesh/driller1-logo.obj"
       // file: "mesh/cone1.obj"

        Pos { x: sync("logo.x")+getSavePointX("drillerNokka"); y: sync("logo.y")+getSavePointY("drillerNokka"); z: sync("logo.z")+getSavePointZ("drillerNokka"); }
        Rot { d: sync("logoRot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync("logoRot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync("logoRot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync("logoScale"); x: 1.0; y: 1.0; z: 1.0 }

    }



    DrawMesh {
//        Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        property string name: "mesh2"
        file: "mesh/scene1-rinkula2.obj"
       // file: "mesh/cone1.obj"

        Pos { x: sync("rinkula.x")+getSavePointX("drillerNokka");
              y: sync("rinkula.y")+getSavePointY("drillerNokka");
              z: sync("rinkula.z")+getSavePointZ("drillerNokka"); }
        Rot { d: sync("rinkulaRot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync("rinkulaRot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync("rinkulaRot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync("rinkulaScale"); x: 1.0; y: 1.0; z: 1.0 }

    }

    DrawMesh {
//        Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        property string name: "mesh2"
        file: "mesh/scene1-nelio1.obj"

        Pos { x: sync("nelio.x")+getSavePointX("drillerNokka");
              y: sync("nelio.y")+getSavePointY("drillerNokka");
              z: sync("nelio.z")+getSavePointZ("drillerNokka"); }
        Rot { d: sync("nelioRot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: sync("nelioRot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: sync("nelioRot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync("nelioScale"); x: 1.0; y: 1.0; z: 1.0 }

    }



/*
    DrawMesh {
//        Clear { cR: 0.150; cG: 0.150; cB: 0.30 }
        property string name: "mesh2"
       // file: "mesh/Drill002.dae"
        file: "mesh/cone1.obj"

        Pos { x: sync("drill.x"); y: sync("drill.y")+0.5; z: sync("drill.z"); }
        Rot { d: sync("drillRot"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 0.6; x: 1.0; y: 4.0; z: 1.0 }

        SavePoint {
            target: "driller"
            x: 0.0; y: 0.0; z: 0.0;
        }

    }
*/


    DrawMesh {
       // file: "mesh/Drill002.dae"
        file: "mesh/plane.x"
        Pos { x: sync("drill.x"); y: sync("drill.y")+5.0; z: sync("drill.z"); }
        Rot { d: sync("drillRot"); ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 0.0; x: 1.0; y: 4.0; z: 1.0 }
        SavePoint {
            target: "drillerMotor"
            x: 0.0; y: 0.0; z: 0.0;
        }
    }



    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/bokeh5.png"
        //    source: "../../images/noisep1s.png"
        }
    }


    Texture {
        textureUnit: 1
        textureItem: joojoo
        Image {
            id: joojoo
            visible: false
         //   source: "../../images/apo-mist-9090724-357_2.png"
            source: "../../images/random16.png"
        //    source: "../../images/noisep1s.png"
         //   source: "../../images/adapt_logo2_full.png"
        }
    }

    Shader {
        file: sceneDir+"ssPartTrans"
        tfVaryings: "vec3 posG; vec2 uvG;"
    }

    property int partW: 500
    property int partH: 500

    DrawVB {
        enabled: true
        type: "pointGrid"
        gridWidth: partW //windowWidth/4
        gridHeight: partH// windowHeight/4
        tfVaryings: "vec3 posG; vec2 uvG;"
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }

    Shader {
        file: sceneDir+"ssPart"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        gridWidth: partW //windowWidth/4
        gridHeight: partH // windowHeight/4
        tfVaryings: "vec3 posG; vec2 uvG;"
        depthTest: true
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }



    Vignette {
        posX: getSavePointX2D("driller")
        posY: getSavePointY2D("driller")
    }
    GodRay {
        godRayX: getSavePointX2D("drillerMotor")
        godRayY: getSavePointY2D("drillerMotor")
    }
    Tonemap {
    }


    DrawOverlaySub {
        posX: sync("ovlSub.posX")
        posY: sync("ovlSub.posY")
        overlayScale: sync("ovlSub.scale")
        overlayAlpha: sync("ovlSub.alpha")
        file: "PinkMedusa.png"
    }


    DrawOverlayMul {
        posX: sync("ovlSub.posX")
        posY: sync("ovlSub.posY")
        overlayScale: sync("ovlSub.scale")
        overlayAlpha: sync("ovlMul.alpha")
        file: "PinkMedusa.png"
    }


}
