function intro()
{
    this.start_time = 0;
    this.end_time = 0;

    var logo =0;
    var alive=0;
    var overlay3;


	  this.angularSpeed = 0.2; 
    this.lastTime = 0;
    this.renderer, this.scene, this.camera;
    this.angleChange;
    this.particles;
    this.composer;
    this.mirror;

    this.aBloomFactor = 1, this.aBloomStrength = 1.5; // Adjust parameters as you want
    this.aEffectCopy;
    this.aEffectBloom;
    this.aRenderModel;

    this.light, this.light0;
    this.renderer, this.scene, this.camera;
    
    this.material;
    this.accum = 0;
    
    
		var geometry, i, h, color, colors = [], sprite, size;

    this.init = function(renderer, camera)
    {      

      this.renderer = renderer;

      this.scene = new THREE.Scene();

      this.camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 1, 10000 );

      
      // var ambient = new THREE.AmbientLight( 0x444444 );
			// scene.add( ambient );


      // Create Particle System ---------------------------------------------------------------------------------------
			geometry = new THREE.Geometry();
      sprite = THREE.ImageUtils.loadTexture("images/particle2.png");

      var pMaterial = new THREE.ParticleBasicMaterial({
            color: 0x666666,
            size: 30,
            map: sprite,
            blending: THREE.AdditiveBlending,
            transparent: true
          });

				for (var i = 0; i < 1000; i ++ ) 
				{

					var vertex = new THREE.Vector3();
					vertex.x = 2000 * Math.random() - 1000;
					vertex.y = 2000 * Math.random() - 1000;
					vertex.z = 1000 * Math.random() - 1000;

          // create a velocity vector
          vertex.velocity = new THREE.Vector3(
            0,              // x
            -Math.random()*30, // y: random vel
            0);  

					geometry.vertices.push( vertex );

					colors[i] = new THREE.Color( 0xffffff );

					// colors[ i ].setHSL( ( vertex.x + 1000 ) / 2000, 1, 0.5 );
					// colors[ i ].setHSL( 1, 1, 1 );

				}

			geometry.colors = colors;			

      this.particles = new THREE.ParticleSystem( geometry, pMaterial);

      // Add particles to sceneGraph
      this.scene.add(this.particles);
      this.particles.sortParticles = true;


      // Create Cubemap -------------------------------------------------------------------------------------------
      var path = "assets/cube/";
			var format = '.jpg';
			var urls = [
					path + 'posx_1' + format, path + 'negx_1' + format,
					path + 'posy_1' + format, path + 'negy_1' + format,
					path + 'posz_1' + format, path + 'negz_1' + format
				];

			var reflectionCube = THREE.ImageUtils.loadTextureCube( urls );
			reflectionCube.format = THREE.RGBFormat;

      var cubeMaterial = new THREE.MeshLambertMaterial( { color: 0xff0000, ambient: 0xff0000, specular: 0xff0000, envMap: reflectionCube, combine: THREE.MixOperation, reflectivity: 0.1 } );

      // Add Synrj logo to sceneGraph ------------------------------------------------------------------------------

      var loader = new THREE.OBJLoader();
      var scene = this.scene;      
      // var obj_map = this.blob_text;
      // var obj_bumpmap = this.blob_text_norms;
      loader.load('assets/syn_logo.obj', function(object) 
      {
        object.traverse(function(child) 
        {

          if (child instanceof THREE.Mesh) 
          {
            child.material.specular = 0x000000;
            child.material = cubeMaterial;

          }

        });

        object.position.z = 170;
        scene.add(object);        
        logo = object; 

      }); 


      logo.material = cubeMaterial;
      
      
      // Add Alive logo to sceneGraph ------------------------------------------------------------------------------

      var loader = new THREE.OBJLoader();
      var scene = this.scene;      
      // var obj_map = this.blob_text;
      // var obj_bumpmap = this.blob_text_norms;
      loader.load('assets/alive_logo.obj', function(object) 
      {
        object.traverse(function(child) 
        {

          if (child instanceof THREE.Mesh) 
          {
            child.material.specular = 0x000000;
            child.material = cubeMaterial;

          }

        });

        scene.add(object);        
        alive = object; 

      }); 


      alive.material = cubeMaterial;


      // Create City Overlay ----------------------------------------------------------------------------------------
      var map = THREE.ImageUtils.loadTexture( 'images/city1.png' );
			map.wrapS = map.wrapT = THREE.RepeatWrapping;
      map.repeat.set( 3, 1 );

			var material = new THREE.MeshLambertMaterial( { 
        color: 0xffffff, 
        map: map, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material.opacity = 0.4;
      
      var overlay1 = new THREE.Mesh( new THREE.PlaneGeometry( 250, 150, 1, 1 ), material );
      overlay1.position.set( 0, 0, -50 );
      
      this.scene.add( overlay1 );
      
      // Create Bokeh Overlay ----------------------------------------------------------------------------------------
      var map2 = THREE.ImageUtils.loadTexture( 'images/bokeh1.png' );
			map2.wrapS = map2.wrapT = THREE.RepeatWrapping;
      map2.repeat.set( 2, 1 );

			var material2 = new THREE.MeshLambertMaterial( { 
        color: 0xffffff, 
        map: map2, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material2.opacity = 0.8;
      
      var overlay2 = new THREE.Mesh( new THREE.PlaneGeometry( 250, 150, 1, 1 ), material2 );
      overlay2.position.set( 0, 0, -49 );
      
      this.scene.add( overlay2 );
      
      // Create Circle Overlay ----------------------------------------------------------------------------------------
      var map3 = THREE.ImageUtils.loadTexture( 'images/circle1.png' );
			map3.wrapS = map3.wrapT = THREE.RepeatWrapping;
      map3.repeat.set( 1, 1 );

			var material3 = new THREE.MeshLambertMaterial( { 
        color: 0xffffff, 
        map: map3, 
        side: THREE.FrontSide,  
        transparent: true,
        depthTest: false
      } );
      material3.opacity = 0.8;
      
      overlay3 = new THREE.Mesh( new THREE.PlaneGeometry( 250, 250, 1, 1 ), material3 );
      overlay3.position.set( 0, 0, -48 );
      
      this.scene.add( overlay3 );               
       

      // Create bloom in order to create glow effet
      this.aBloomFactor = 1.5, this.aBloomStrength = 1.5; // Adjust parameters as you want
      this.aEffectBloom = new THREE.BloomPass( this.aBloomStrength, this.aBloomFactor * 25.0, this.aBloomFactor * 4.0, 512 );
     
      // Create the post-effect system
      this.aEffectCopy = new THREE.ShaderPass( THREE.CopyShader );
      this.aEffectCopy.renderToScreen = true;    
      this.aRenderModel = new THREE.RenderPass( this.scene, this.camera );
     
      // Create the rendering pass
      this.composer = new THREE.EffectComposer( this.renderer );
      this.composer.addPass( this.aRenderModel );
      this.composer.addPass( this.aEffectBloom );
      this.composer.addPass( this.aEffectCopy );
              


      this.light = new THREE.SpotLight( 0xffffff, 1.25 );
      this.light.position.set(-50, 90, 60);
      this.light.target.position.set( 0, 0, 0);
      //this.light.castShadow = true;
      this.scene.add(this.light);

      this.light1 = new THREE.SpotLight( 0xffffff, 1.25 );
      this.light1.position.set(0, 0, -20);
      this.light1.target.position.set( 0, 0, 0);
      this.scene.add(this.light1);
      
    }

    this.setupRenderer = function(){
    
      this.renderer.setClearColor( 0x444444, 1.0 );
      this.camera.fov = 45;
      this.camera.position.y = 0;
      this.camera.rotation.z = 0;

      
      this.camera.updateProjectionMatrix();
            
      this.camera.position.z = 100;  
      this.camera.rotation.z = 0.0;     
      this.renderer.autoClear  = false;    
    }

    this.preRenderer = function(){
        this.composer.render();    
    }
    
    this.render = function(demoFrame)
    {

        //key('a', function(){ this.aBloomFactor = 0.5});
        this.accum = demoFrame;

    	  this.angleChange = this.angularSpeed * demoFrame * 2 * Math.PI / 1000;

            for(var i = 0; i < this.particles.geometry.vertices.length; i++ ){
                
                var particle = this.particles.geometry.vertices[i];
                // and the position
          			particle.position += 2.0;
                this.particles.geometry.verticesNeedUpdate = true;
                
            }


        this.particles.rotation.y -= demoFrame*0.02;
        
        alive.rotation.y = 0.5*Math.sin(clock.getElapsedTime()*0.14);
        alive.position.y += 0.2;
        
        logo.rotation.y += demoFrame*0.6;
        
        if(clock.getElapsedTime() > 23.5)
          logo.position.z -= this.accum*11.5;
          //logo.position.z = 250 - 250.0*Math.sin(clock.getElapsedTime()*0.3);
        
        overlay3.rotation.z += demoFrame*0.1;
      
        
        //this.renderer.render(this.scene, this.camera);
        this.light.position.x = 200.0*Math.cos(demoFrame);
        this.light.position.y = 200.0*Math.sin(demoFrame);

        this.renderer.clear();
        this.composer.render();
    }
}