function(check_include_directory dir)
  set(dir_mode "")
  if(ARGV1)
    string(TOLOWER "${ARGV1} " dir_mode)
  endif()
  set(output_message "-- Looking for ${dir_mode}include directory '${dir}' - ")
  if(EXISTS "${dir}/")
    message("${output_message}found")
    if(ARGV1)
      include_directories("${ARGV1}" "${dir}")
    else()
      include_directories("${dir}")
    endif()
  else()
    message("${output_message}not found")
  endif()
endfunction()

function(find_pkgconfig package)
  include(FindPkgConfig)
  set(lib_mode SHARED)
  if(ARGV2)
    set(lib_mode "${ARGV2}")
  endif()
  pkg_search_module(PKG_CONFIG_TEMP "${package}")
  if(PKG_CONFIG_TEMP_FOUND)
    if(PKG_CONFIG_TEMP_INCLUDE_DIRS)
      include_directories("${PKG_CONFIG_TEMP_INCLUDE_DIRS}")
    endif()
    if(PKG_CONFIG_TEMP_LIBRARY_DIRS)
      link_directories("${PKG_CONFIG_TEMP_LIBRARY_DIRS}")
    endif()
    if(PGK_CONFIG_TEMP_CFLAGS)
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${PKG_CONFIG_TEMP_CFLAGS}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${PKG_CONFIG_TEMP_CFLAGS}")
    endif()
    if(PGK_CONFIG_TEMP_CFLAGS_OTHER)
      set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${PKG_CONFIG_TEMP_CFLAGS_OTHER}")
      set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${PKG_CONFIG_TEMP_CFLAGS_OTHER}")
    endif()
    if(PGK_CONFIG_TEMP_LDFLAGS)
      set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${PKG_CONFIG_TEMP_LDFLAGS}")
    endif()
    if(PGK_CONFIG_TEMP_LDFLAGS_OTHER)
      set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${PKG_CONFIG_TEMP_LDFLAGS_OTHER}")
    endif()
    if(PKG_CONFIG_TEMP_LIBRARIES)
      add_library("${PKG_CONFIG_TEMP_LIBRARIES}" IMPORTED "${lib_mode}")
    endif()
    message("-- Found ${package}: ${PKG_CONFIG_TEMP_VERSION}")
  elseif(ARGV1)
    message(SEND_ERROR "${package} required but not found")
  endif()
  unset(PKG_CONFIG_TEMP_INCLUDE_DIRS)
  unset(PKG_CONFIG_TEMP_LIBRARY_DIRS)
  unset(PKG_CONFIG_TEMP_CFLAGS)
  unset(PKG_CONFIG_TEMP_CFLAGS_OTHER)
  unset(PKG_CONFIG_TEMP_LDFLAGS)
  unset(PKG_CONFIG_TEMP_LDFLAGS_OTHER)
  unset(PKG_CONFIG_TEMP_LIBRARIES_DIRS)
  unset(PKG_CONFIG_TEMP_VERSION)
endfunction()

function(find_boost)
  find_package(Boost 1.42.0)
  if(Boost_FOUND)
    include_directories(${Boost_INCLUDE_DIRS})
    add_library("${Boost_LIBRARIES}" IMPORTED STATIC)
  elseif(ARGV0)
    message(SEND_ERROR "Boost required but not found")
  endif()
endfunction()

function(find_gl)
  include(FindOpenGL)
  if(OPENGL_FOUND)
    add_library("${OPENGL_gl_LIBRARY}" IMPORTED SHARED)
  elseif(ARGV0)
    message(SEND_ERROR "GL required but not found")
  endif()
endfunction()

function(find_glew)
  if(ARGV1)
    find_pkgconfig(glew "${ARGV0}" "${ARGV1}")
  elseif(ARGV0)
    find_pkgconfig(glew "${ARGV0}")
  else()
    find_pkgconfig(glew)
  endif()
endfunction()

function(find_glu)
  include(FindOpenGL)
  if(OPENGL_GLU_FOUND)
    add_library("${OPENGL_glu_LIBRARY}" IMPORTED SHARED)
    message("-- Found GLU: ${OPENGL_glu_LIBRARY}")
  elseif(ARGV0)
    message(SEND_ERROR "GLU required but not found")
  endif()
endfunction()

function(find_sdl)
  include(FindSDL)
  set(lib_mode SHARED)
  if(ARGV1)
    set(lib_mode ARGV1)
  endif()
  if(SDL_FOUND)
    include_directories("${SDL_INCLUDE_DIR}")
    add_library("${SDL_LIBRARY}" IMPORTED "${lib_mode}")
  elseif(ARGV0)
    message(SEND_ERROR "SDL required but not found")
  endif()
endfunction()

check_include_directory("/opt/include")
check_include_directory("/opt/lib")
check_include_directory("/opt/local/include")
check_include_directory("/opt/local/lib")
check_include_directory("/sw/include")
check_include_directory("/sw/lib")
check_include_directory("/usr/local/include" SYSTEM)
check_include_directory("/usr/local/lib")
check_include_directory("/usr/X11R6/include")
check_include_directory("/usr/X11R6/lib")
