import pygame
from pygame import *
from game import *
from macro import *

from menu import *
from intro import *
from credits import *
from settings import *

def main():
	"""
	Main game function. Called upon starting the game.
	"""

	#init pygame
	pygame.init()
	pygame.mixer.init()
	
	#init display
	screen = display.set_mode(DISPLAY)
	pygame.display.set_icon(pygame.image.load("assets/sprites/luridiformis.png").convert())

	display.set_caption("Fungus Time")

	#create background surfaces
	background = pygame.Surface(DISPLAY)
	background = background.convert()
	background.fill((0, 0, 0))

	#init timer
	timer = time.Clock()

	playerAlive = True

	"""
	This is the main loop for the whole framework
	"""

	while 1:

		"""
		Black prescreen if I want to record intro and gameplay
		"""

		record = False
		while record:
			for e in pygame.event.get():
				#press a key
				if e.type == KEYDOWN:
					if e.key == K_z:
						record = False


		"""
		Intro
		"""

		#init the intro
		intro = Intro()

		if playerAlive:
			#load and play intro narration
			narration = pygame.mixer.Sound("assets/sound/narration.wav")
			narration.play()

			introDisplay = True
			
		if not introDisplay:
			#showcase purposes
			narration.stop()

		#while loop for intro
		while introDisplay and playerAlive:
			#make sure framerate is capped at 60fps
			timer.tick(60)

			screen.blit(background, (0,0))

			#Handle keyevents
			for e in pygame.event.get():
				checkQuit(e)
				
				#skip intro with space
				if e.type == KEYDOWN:
					if e.key == K_SPACE:
						introDisplay = False
						narration.stop()

			#draw intro slide
			dirty = intro.draw(screen)

			pygame.display.update()

			if intro.finished:
				introDisplay = False # or break

		"""
		Menu
		"""

		#load and play menu music
		if playerAlive:
			playMusic("DST-DarkSeraphim")
		else:
			playMusic("DST-Petaluna")

		#init the menu
		menu = Menu()

		menuDisplay = True

		#while loop for menu
		while menuDisplay:
			#make sure framerate is capped at 60fps
			timer.tick(60)

			#Handle keyevents
			for e in pygame.event.get():
				checkQuit(e)

				#handle input
				if menu.handleEvent(e):
					menuDisplay = False # or break

				#start game with space
				if e.type == KEYDOWN:
					if e.key == K_SPACE:
						menuDisplay = False

			#draw menu objects
			dirty = menu.draw(screen, playerAlive)

			#update display
			if dirtOpt:
				#use dirty rectangles
				pygame.display.update(dirty)

			else:
				pygame.display.update()

		"""
		Game
		"""

		#init the game
		game = Game()

		#load and play menu music
		if not playerAlive:
			playMusic("DST-DarkSeraphim")

		playerAlive = True

		#main loop for game
		while playerAlive:
			#make sure framerate is capped at 60fps
			timer.tick(60)

			#Handle keyevents
			for e in pygame.event.get():
				checkQuit(e)

				#handle key
				game.handleKey(e)

			#update game objects
			playerAlive = game.update()

			#draw game objects
			dirty = game.draw(screen)

			#update display
			if dirtOpt:
				#use dirty rectangles
				pygame.display.update(dirty)

			else:
				pygame.display.update()

		"""
		Credits
		"""
		credits_running = True
		c = Credits()

		while credits_running:
			#make sure framerate is capped at 60fps
			timer.tick(60)

			screen.blit(background, (0,0))

			credits_running = c.draw(screen)

			#Handle keyevents
			for e in pygame.event.get():
				checkQuit(e)
				
				#skip intro with space
				if e.type == KEYDOWN:
					if e.key == K_SPACE:
						credits_running = False

			pygame.display.update()


def checkQuit(e):
	"""
	Quits if given event is QUIT or ESCAPE
	"""

	if e.type == QUIT:
		raise SystemExit, "QUIT"

	if e.type == KEYDOWN:
		if e.key == K_ESCAPE: 
			raise SystemExit, "Quit"

		
if(__name__ == "__main__"):
	main()
