#version 110
uniform ivec2 resolution;
uniform float offset;
uniform float constant;
uniform float linear;
uniform float quadric;
uniform sampler2D diffuse;
uniform sampler2D normals;
uniform float zoom;
uniform vec2 position;
uniform float scale;
uniform vec4 color;
void main()
{
     vec2 screencoord    = gl_FragCoord.xy;
          screencoord.y  = float(resolution.y) - screencoord.y;
     vec2 fractioncoord  = screencoord / vec2(resolution);
     vec2 screendistance = screencoord - position;
     vec2 lightvector    = screendistance / zoom / scale;
    float lightdistance  = length(lightvector);
    float lightdistance2 = lightdistance * lightdistance;
     vec4 diffusecolor   = texture2D(diffuse, fractioncoord);
     vec4 normalscolor   = texture2D(normals, fractioncoord);
     vec3 normalsvector  = 1.0 - 2.0 * normalscolor.xyz;
          normalsvector *= vec3(1,-1,1);
          normalsvector.z= 1.0 - cos(normalsvector.x) - cos(normalsvector.y);
          normalsvector  = normalize(normalsvector);
    float normalspass    = max(dot(normalsvector, normalize(vec3(lightvector, -offset))), 0.0);
    float attenuation    = 1.0 / (constant + linear * lightdistance + quadric * lightdistance2);
     vec3 lightpass      = normalspass * attenuation * color.rgb;
     vec4 colorpass      = vec4(diffusecolor.rgb * lightpass, diffusecolor.a);
          gl_FragColor   = colorpass;
}